/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.CompositeIndex;
import io.permazen.core.CoreIndex2;
import io.permazen.core.CoreIndex3;
import io.permazen.core.CoreIndex4;
import io.permazen.core.FieldType;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.Index2View;
import io.permazen.core.Index3View;
import io.permazen.core.Index4View;
import io.permazen.core.IndexStorageInfo;
import io.permazen.core.ObjId;
import io.permazen.core.SchemaItem;
import io.permazen.core.SimpleField;
import io.permazen.core.Transaction;
import io.permazen.kv.KVStore;
import java.util.ArrayList;
import java.util.List;

class CompositeIndexStorageInfo
extends IndexStorageInfo {
    final List<Integer> storageIds;
    final List<FieldType<?>> fieldTypes;

    CompositeIndexStorageInfo(CompositeIndex index) {
        super(index.storageId);
        this.storageIds = new ArrayList<Integer>(index.fields.size());
        index.fields.stream().map(SchemaItem::getStorageId).forEach(this.storageIds::add);
        this.fieldTypes = new ArrayList(index.fields.size());
        index.fields.stream().map(SimpleField::getFieldType).map(FieldType::genericizeForIndex).forEach(this.fieldTypes::add);
    }

    Object getIndex(Transaction tx) {
        switch (this.storageIds.size()) {
            case 2: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1));
            }
            case 3: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1), this.fieldTypes.get(2));
            }
            case 4: {
                return this.buildIndex(tx, this.fieldTypes.get(0), this.fieldTypes.get(1), this.fieldTypes.get(2), this.fieldTypes.get(3));
            }
        }
        throw new RuntimeException("internal error");
    }

    private <V1, V2> CoreIndex2<V1, V2, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type) {
        return new CoreIndex2<V1, V2, ObjId>((KVStore)tx.kvt, new Index2View<V1, V2, ObjId>(this.storageId, value1Type, value2Type, FieldTypeRegistry.OBJ_ID));
    }

    private <V1, V2, V3> CoreIndex3<V1, V2, V3, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type) {
        return new CoreIndex3<V1, V2, V3, ObjId>((KVStore)tx.kvt, new Index3View<V1, V2, V3, ObjId>(this.storageId, value1Type, value2Type, value3Type, FieldTypeRegistry.OBJ_ID));
    }

    private <V1, V2, V3, V4> CoreIndex4<V1, V2, V3, V4, ObjId> buildIndex(Transaction tx, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<V4> value4Type) {
        return new CoreIndex4<V1, V2, V3, V4, ObjId>((KVStore)tx.kvt, new Index4View<V1, V2, V3, V4, ObjId>(this.storageId, value1Type, value2Type, value3Type, value4Type, FieldTypeRegistry.OBJ_ID));
    }

    @Override
    public String toString() {
        return "composite index on fields " + this.fieldTypes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompositeIndexStorageInfo that = (CompositeIndexStorageInfo)obj;
        return this.storageIds.equals(that.storageIds) && this.fieldTypes.equals(that.fieldTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.storageIds.hashCode() ^ this.fieldTypes.hashCode();
    }
}

