/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.AbstractCoreIndex;
import io.permazen.core.IndexKeyFilter;
import io.permazen.core.IndexMap;
import io.permazen.core.IndexSet;
import io.permazen.core.IndexView;
import io.permazen.core.type.Tuple2FieldType;
import io.permazen.index.Index;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.tuple.Tuple2;
import io.permazen.util.Bounds;
import java.util.NavigableMap;
import java.util.NavigableSet;

public class CoreIndex<V, T>
extends AbstractCoreIndex
implements Index<V, T> {
    CoreIndex(KVStore kv, IndexView<V, T> indexView) {
        super(kv, 2, indexView);
    }

    @Override
    public CoreIndex<V, T> filter(int index, KeyFilter filter) {
        return new CoreIndex<V, T>(this.kv, this.getIndexView().filter(index, filter));
    }

    IndexView<V, T> getIndexView() {
        return (IndexView)this.indexView;
    }

    public NavigableSet<Tuple2<V, T>> asSet() {
        IndexView<V, T> iv = this.getIndexView();
        Tuple2FieldType<V, T> tupleFieldType = new Tuple2FieldType<V, T>(iv.getValueType(), iv.getTargetType());
        IndexSet indexSet = new IndexSet(this.kv, tupleFieldType, iv.prefixMode, iv.prefix);
        if (iv.hasFilters()) {
            indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, iv, 2));
        }
        return indexSet;
    }

    public NavigableMap<V, NavigableSet<T>> asMap() {
        IndexView<V, T> iv = this.getIndexView();
        IndexMap indexMap = new IndexMap.OfValues<V, T>(this.kv, iv);
        if (this.indexView.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, iv, 1));
        }
        return indexMap;
    }

    public CoreIndex<V, T> withValueBounds(Bounds<V> bounds) {
        return (CoreIndex)this.filter(0, this.getIndexView().getValueType(), bounds);
    }

    public CoreIndex<V, T> withTargetBounds(Bounds<T> bounds) {
        return (CoreIndex)this.filter(1, this.getIndexView().getTargetType(), bounds);
    }
}

