/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.AbstractCoreIndex;
import io.permazen.core.CoreIndex;
import io.permazen.core.CoreIndex2;
import io.permazen.core.Index2View;
import io.permazen.core.Index3View;
import io.permazen.core.IndexKeyFilter;
import io.permazen.core.IndexMap;
import io.permazen.core.IndexSet;
import io.permazen.core.IndexView;
import io.permazen.core.type.Tuple4FieldType;
import io.permazen.index.Index;
import io.permazen.index.Index2;
import io.permazen.index.Index3;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.tuple.Tuple2;
import io.permazen.tuple.Tuple3;
import io.permazen.tuple.Tuple4;
import io.permazen.util.Bounds;
import java.util.NavigableMap;
import java.util.NavigableSet;

public class CoreIndex3<V1, V2, V3, T>
extends AbstractCoreIndex
implements Index3<V1, V2, V3, T> {
    CoreIndex3(KVStore kv, Index3View<V1, V2, V3, T> indexView) {
        super(kv, 4, indexView);
    }

    @Override
    public CoreIndex3<V1, V2, V3, T> filter(int index, KeyFilter filter) {
        return new CoreIndex3<V1, V2, V3, T>(this.kv, this.getIndex3View().filter(index, filter));
    }

    Index3View<V1, V2, V3, T> getIndex3View() {
        return (Index3View)this.indexView;
    }

    public NavigableSet<Tuple4<V1, V2, V3, T>> asSet() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        Tuple4FieldType<V1, V2, V3, T> fieldType = new Tuple4FieldType<V1, V2, V3, T>(iv.getValue1Type(), iv.getValue2Type(), iv.getValue3Type(), iv.getTargetType());
        IndexSet indexSet = new IndexSet(this.kv, fieldType, iv.prefixMode, iv.prefix);
        if (iv.hasFilters()) {
            indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, iv, 4));
        }
        return indexSet;
    }

    public NavigableMap<Tuple3<V1, V2, V3>, NavigableSet<T>> asMap() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        IndexView<Tuple3<V1, V2, V3>, T> tupleIV = iv.asTuple3IndexView();
        IndexMap indexMap = new IndexMap.OfValues<Tuple3<V1, V2, V3>, T>(this.kv, tupleIV);
        if (tupleIV.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, tupleIV, 1));
        }
        return indexMap;
    }

    public NavigableMap<Tuple2<V1, V2>, Index<V3, T>> asMapOfIndex() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        Index2View<Tuple2<V1, V2>, V3, T> tupleIV = iv.asTuple2Index2View();
        IndexMap indexMap = new IndexMap.OfIndex<Tuple2<V1, V2>, V3, T>(this.kv, tupleIV);
        if (iv.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, tupleIV, 1));
        }
        return indexMap;
    }

    public NavigableMap<V1, Index2<V2, V3, T>> asMapOfIndex2() {
        Index3View<V1, V2, V3, T> iv = this.getIndex3View();
        IndexMap indexMap = new IndexMap.OfIndex2<V1, V2, V3, T>(this.kv, iv);
        if (iv.hasFilters()) {
            indexMap = indexMap.filterKeys(new IndexKeyFilter(this.kv, iv, 1));
        }
        return indexMap;
    }

    public CoreIndex2<V1, V2, V3> asIndex2() {
        return new CoreIndex2<V1, V2, V3>(this.kv, this.getIndex3View().asIndex2View());
    }

    public CoreIndex<V1, V2> asIndex() {
        return new CoreIndex<V1, V2>(this.kv, this.getIndex3View().asIndex2View().asIndexView());
    }

    public CoreIndex3<V1, V2, V3, T> withValue1Bounds(Bounds<V1> bounds) {
        return (CoreIndex3)this.filter(0, this.getIndex3View().getValue1Type(), bounds);
    }

    public CoreIndex3<V1, V2, V3, T> withValue2Bounds(Bounds<V2> bounds) {
        return (CoreIndex3)this.filter(1, this.getIndex3View().getValue2Type(), bounds);
    }

    public CoreIndex3<V1, V2, V3, T> withValue3Bounds(Bounds<V3> bounds) {
        return (CoreIndex3)this.filter(2, this.getIndex3View().getValue3Type(), bounds);
    }

    public CoreIndex3<V1, V2, V3, T> withTargetBounds(Bounds<T> bounds) {
        return (CoreIndex3)this.filter(3, this.getIndex3View().getTargetType(), bounds);
    }
}

