/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.permazen.core.FieldSwitch;
import io.permazen.core.ObjId;
import io.permazen.core.Schema;
import io.permazen.core.SchemaItem;
import io.permazen.core.Transaction;
import io.permazen.core.util.ObjIdMap;
import io.permazen.util.ByteWriter;
import io.permazen.util.UnsignedIntEncoder;

public abstract class Field<T>
extends SchemaItem {
    final TypeToken<T> typeToken;
    final byte[] encodedStorageId;

    Field(String name, int storageId, Schema schema, TypeToken<T> typeToken) {
        super(name, storageId, schema);
        Preconditions.checkArgument((typeToken != null ? 1 : 0) != 0, (Object)"null typeToken");
        this.typeToken = typeToken;
        this.encodedStorageId = UnsignedIntEncoder.encode((int)this.storageId);
    }

    public TypeToken<T> getTypeToken() {
        return this.typeToken;
    }

    public abstract T getValue(Transaction var1, ObjId var2);

    public abstract boolean hasDefaultValue(Transaction var1, ObjId var2);

    public abstract <R> R visit(FieldSwitch<R> var1);

    abstract void copy(ObjId var1, ObjId var2, Transaction var3, Transaction var4, ObjIdMap<ObjId> var5);

    byte[] buildKey(ObjId id) {
        ByteWriter writer = new ByteWriter(8 + this.encodedStorageId.length);
        id.writeTo(writer);
        writer.write(this.encodedStorageId);
        return writer.getBytes();
    }

    static byte[] buildKey(ObjId id, int storageId) {
        ByteWriter writer = new ByteWriter(8 + UnsignedIntEncoder.encodeLength((int)storageId));
        id.writeTo(writer);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        return writer.getBytes();
    }

    abstract boolean isUpgradeCompatible(Field<?> var1);
}

