/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.CounterField;
import io.permazen.core.EnumField;
import io.permazen.core.Field;
import io.permazen.core.FieldType;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.ListField;
import io.permazen.core.MapField;
import io.permazen.core.ReferenceField;
import io.permazen.core.Schema;
import io.permazen.core.SetField;
import io.permazen.core.SimpleField;
import io.permazen.schema.CounterSchemaField;
import io.permazen.schema.EnumSchemaField;
import io.permazen.schema.ListSchemaField;
import io.permazen.schema.MapSchemaField;
import io.permazen.schema.ReferenceSchemaField;
import io.permazen.schema.SchemaFieldSwitchAdapter;
import io.permazen.schema.SetSchemaField;
import io.permazen.schema.SimpleSchemaField;

class FieldBuilder
extends SchemaFieldSwitchAdapter<Field<?>> {
    final Schema schema;
    final FieldTypeRegistry fieldTypeRegistry;

    FieldBuilder(Schema schema, FieldTypeRegistry fieldTypeRegistry) {
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"null schema");
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        this.schema = schema;
        this.fieldTypeRegistry = fieldTypeRegistry;
    }

    @Override
    public SetField<?> caseSetSchemaField(SetSchemaField field) {
        return this.buildSetField(field, (SimpleField)field.getElementField().visit(this));
    }

    @Override
    public ListField<?> caseListSchemaField(ListSchemaField field) {
        return this.buildListField(field, (SimpleField)field.getElementField().visit(this));
    }

    @Override
    public MapField<?, ?> caseMapSchemaField(MapSchemaField field) {
        return this.buildMapField(field, (SimpleField)field.getKeyField().visit(this), (SimpleField)field.getValueField().visit(this));
    }

    @Override
    public SimpleField<?> caseSimpleSchemaField(SimpleSchemaField field) {
        long signature;
        String fieldTypeName = field.getType();
        FieldType<?> fieldType = this.fieldTypeRegistry.getFieldType(fieldTypeName, signature = field.getEncodingSignature());
        if (fieldType == null) {
            StringBuilder buf = new StringBuilder("unknown field type `" + fieldTypeName + "'");
            if (signature != 0L) {
                buf.append(" with signature ").append(signature);
            }
            buf.append(" for field `").append(field.getName()).append('\'');
            boolean foundAny = false;
            for (FieldType<?> otherFieldType : this.fieldTypeRegistry.getAll()) {
                if (!otherFieldType.getName().equals(fieldTypeName)) continue;
                if (!foundAny) {
                    buf.append(" (note: field type(s) named `").append(fieldTypeName).append("' exist but with different signature(s): ");
                    foundAny = true;
                } else {
                    buf.append(", ");
                }
                buf.append(otherFieldType.getEncodingSignature());
            }
            if (foundAny) {
                buf.append(')');
            }
            throw new IllegalArgumentException(buf.toString());
        }
        return this.buildSimpleField(field, field.getName(), fieldType);
    }

    @Override
    public SimpleField<?> caseReferenceSchemaField(ReferenceSchemaField field) {
        Preconditions.checkArgument((field.getEncodingSignature() == 0L ? 1 : 0) != 0, (Object)"encoding signature must be zero");
        return new ReferenceField(field.getName(), field.getStorageId(), this.schema, field.getOnDelete(), field.isCascadeDelete(), field.isAllowDeleted(), field.isAllowDeletedSnapshot(), field.getObjectTypes());
    }

    @Override
    public EnumField caseEnumSchemaField(EnumSchemaField field) {
        Preconditions.checkArgument((field.getEncodingSignature() == 0L ? 1 : 0) != 0, (Object)"encoding signature must be zero");
        return new EnumField(field.getName(), field.getStorageId(), this.schema, field.isIndexed(), field.getIdentifiers());
    }

    @Override
    public CounterField caseCounterSchemaField(CounterSchemaField field) {
        return new CounterField(field.getName(), field.getStorageId(), this.schema);
    }

    private <T> SimpleField<T> buildSimpleField(SimpleSchemaField field, String fieldName, FieldType<T> fieldType) {
        assert (field.getEncodingSignature() == fieldType.getEncodingSignature());
        return new SimpleField<T>(fieldName, field.getStorageId(), this.schema, fieldType, field.isIndexed());
    }

    private <E> SetField<E> buildSetField(SetSchemaField field, SimpleField<E> elementField) {
        return new SetField<E>(field.getName(), field.getStorageId(), this.schema, elementField);
    }

    private <E> ListField<E> buildListField(ListSchemaField field, SimpleField<E> elementField) {
        return new ListField<E>(field.getName(), field.getStorageId(), this.schema, elementField);
    }

    private <K, V> MapField<K, V> buildMapField(MapSchemaField field, SimpleField<K> keyField, SimpleField<V> valueField) {
        return new MapField<K, V>(field.getName(), field.getStorageId(), this.schema, keyField, valueField);
    }
}

