/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldType;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.kv.util.AbstractKVNavigableMap;
import io.permazen.util.Bounds;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import java.util.Collections;
import java.util.Comparator;

abstract class FieldTypeMap<K, V>
extends AbstractKVNavigableMap<K, V> {
    final FieldType<K> keyFieldType;
    final byte[] prefix;

    FieldTypeMap(KVStore kv, FieldType<K> keyFieldType, boolean prefixMode, byte[] prefix) {
        this(kv, keyFieldType, prefixMode, false, prefix, KeyRange.forPrefix((byte[])prefix), null, new Bounds());
    }

    FieldTypeMap(KVStore kv, FieldType<K> keyFieldType, boolean prefixMode, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<K> bounds) {
        super(kv, prefixMode, reversed, keyRange, keyFilter, bounds);
        Preconditions.checkArgument((keyFieldType != null ? 1 : 0) != 0, (Object)"null keyFieldType");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"null keyRange");
        if (!KeyRange.forPrefix((byte[])prefix).contains(keyRange)) {
            throw new IllegalArgumentException(keyRange + " does not restrict to prefix " + ByteUtil.toString((byte[])prefix));
        }
        this.keyFieldType = keyFieldType;
        this.prefix = prefix;
    }

    public final Comparator<? super K> comparator() {
        return this.reversed ? Collections.reverseOrder(this.keyFieldType) : this.keyFieldType;
    }

    protected void encodeKey(ByteWriter writer, Object obj) {
        writer.write(this.prefix);
        this.keyFieldType.validateAndWrite(writer, obj);
    }

    protected K decodeKey(ByteReader reader) {
        assert (ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])reader.getBytes()));
        reader.skip(this.prefix.length);
        return this.keyFieldType.read(reader);
    }
}

