/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldType;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.kv.util.AbstractKVNavigableSet;
import io.permazen.util.Bounds;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import java.util.Collections;
import java.util.Comparator;

abstract class FieldTypeSet<E>
extends AbstractKVNavigableSet<E> {
    final FieldType<E> fieldType;
    final byte[] prefix;

    FieldTypeSet(KVStore kv, FieldType<E> fieldType, boolean prefixMode, byte[] prefix) {
        this(kv, fieldType, prefixMode, false, prefix, KeyRange.forPrefix((byte[])prefix), null, new Bounds());
    }

    FieldTypeSet(KVStore kv, FieldType<E> fieldType, boolean prefixMode, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<E> bounds) {
        super(kv, prefixMode, reversed, keyRange, keyFilter, bounds);
        Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"null prefix");
        Preconditions.checkArgument((prefix.length == 0 || keyRange != null ? 1 : 0) != 0, (Object)"null keyRange");
        if (keyRange != null && !KeyRange.forPrefix((byte[])prefix).contains(keyRange)) {
            throw new IllegalArgumentException(keyRange + " does not restrict to prefix " + ByteUtil.toString((byte[])prefix));
        }
        this.fieldType = fieldType;
        this.prefix = prefix;
    }

    public final Comparator<? super E> comparator() {
        return this.reversed ? Collections.reverseOrder(this.fieldType) : this.fieldType;
    }

    protected void encode(ByteWriter writer, Object obj) {
        writer.write(this.prefix);
        this.fieldType.validateAndWrite(writer, obj);
    }

    protected E decode(ByteReader reader) {
        assert (ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])reader.getBytes()));
        reader.skip(this.prefix.length);
        return this.fieldType.read(reader);
    }
}

