/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import io.permazen.core.FieldType;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyFilterUtil;
import io.permazen.kv.KeyRanges;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import java.util.Arrays;
import java.util.List;

class FieldTypesFilter
implements KeyFilter {
    private final byte[] prefix;
    private final FieldType<?>[] fieldTypes;
    private final KeyFilter[] filters;

    FieldTypesFilter(byte[] prefix, FieldType<?> ... fieldTypes) {
        Preconditions.checkArgument((fieldTypes != null ? 1 : 0) != 0, (Object)"null fieldTypes");
        this.prefix = prefix != null ? (byte[])prefix.clone() : ByteUtil.EMPTY;
        for (FieldType<?> fieldType : this.fieldTypes = fieldTypes) {
            Preconditions.checkArgument((fieldType != null ? 1 : 0) != 0, (Object)"null fieldType");
        }
        this.filters = new KeyFilter[this.fieldTypes.length];
    }

    FieldTypesFilter(byte[] prefix, FieldType<?>[] fieldTypes, KeyFilter[] filters, int start, int end) {
        this(prefix, Arrays.copyOfRange(fieldTypes, start, end));
        Preconditions.checkArgument((filters != null && filters.length == fieldTypes.length ? 1 : 0) != 0, (Object)"bogus filters");
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            this.filters[i] = filters[start + i];
        }
    }

    private FieldTypesFilter(FieldTypesFilter original) {
        this.prefix = original.prefix;
        this.fieldTypes = original.fieldTypes;
        this.filters = (KeyFilter[])original.filters.clone();
    }

    public List<FieldType<?>> getFieldTypes() {
        return Arrays.asList((Object[])this.fieldTypes.clone());
    }

    public KeyFilter getFilter(int index) {
        return this.filters[index];
    }

    public boolean hasFilters() {
        for (KeyFilter filter : this.filters) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }

    public FieldTypesFilter filter(int index, KeyFilter keyFilter) {
        Preconditions.checkArgument((keyFilter != null ? 1 : 0) != 0, (Object)"null keyFilter");
        if (keyFilter instanceof KeyRanges && ((KeyRanges)keyFilter).isFull()) {
            return this;
        }
        if (this.filters[index] != null) {
            keyFilter = KeyFilterUtil.intersection((KeyFilter[])new KeyFilter[]{keyFilter, this.filters[index]});
        }
        FieldTypesFilter copy = new FieldTypesFilter(this);
        copy.filters[index] = keyFilter;
        return copy;
    }

    public String toString() {
        return "FieldTypesFilter[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",fieldTypes=" + Arrays.asList(this.fieldTypes) + ",filters=" + Arrays.asList(this.filters) + "]";
    }

    public boolean contains(byte[] key) {
        byte[] next = this.seekHigher(key);
        assert (next == null || ByteUtil.compare((byte[])next, (byte[])key) >= 0);
        return next != null && Arrays.equals(next, key);
    }

    public byte[] seekHigher(byte[] key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        if (!ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])key)) {
            if (ByteUtil.compare((byte[])key, (byte[])this.prefix) > 0) {
                return null;
            }
            return this.prefix;
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            int fieldStart = reader.getOffset();
            if (reader.remain() == 0) {
                return ByteUtil.getNextKey((byte[])reader.getBytes(0, fieldStart));
            }
            if (!this.decodeValue(this.fieldTypes[i], reader)) {
                return ByteUtil.getNextKey((byte[])reader.getBytes(0, reader.getOffset()));
            }
            KeyFilter filter = this.filters[i];
            if (filter == null) continue;
            byte[] fieldValue = Arrays.copyOfRange(key, fieldStart, reader.getOffset());
            byte[] next = filter.seekHigher(fieldValue);
            assert (next == null || ByteUtil.compare((byte[])next, (byte[])fieldValue) >= 0);
            if (next == null) {
                if (i == 0) {
                    return null;
                }
                assert (fieldStart > 0);
                try {
                    return ByteUtil.getKeyAfterPrefix((byte[])reader.getBytes(0, fieldStart));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (Arrays.equals(next, fieldValue)) continue;
            byte[] keyFromNext = Bytes.concat((byte[][])new byte[][]{reader.getBytes(0, fieldStart), next});
            return ByteUtil.compare((byte[])keyFromNext, (byte[])key) > 0 ? keyFromNext : ByteUtil.getNextKey((byte[])key);
        }
        return key;
    }

    public byte[] seekLower(byte[] key) {
        boolean fromTheTop;
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"null key");
        boolean bl = fromTheTop = key.length == 0;
        if (!fromTheTop && !ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])key)) {
            if (ByteUtil.compare((byte[])key, (byte[])this.prefix) < 0) {
                return null;
            }
            fromTheTop = true;
        }
        if (fromTheTop) {
            try {
                return ByteUtil.getKeyAfterPrefix((byte[])this.prefix);
            }
            catch (IllegalArgumentException e) {
                return ByteUtil.EMPTY;
            }
        }
        ByteReader reader = new ByteReader(key, this.prefix.length);
        ByteWriter writer = new ByteWriter(key.length);
        writer.write(key, 0, this.prefix.length);
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            FieldType<?> fieldType = this.fieldTypes[i];
            KeyFilter filter = this.filters[i];
            int fieldStart = reader.getOffset();
            boolean decodeOK = this.decodeValue(fieldType, reader);
            int fieldStop = reader.getOffset();
            byte[] fieldValue = Arrays.copyOfRange(key, fieldStart, fieldStop);
            if (filter == null || fieldValue.length == 0) {
                writer.write(fieldValue);
                if (!decodeOK) break;
                assert (fieldValue.length > 0);
                continue;
            }
            byte[] next = filter.seekLower(fieldValue);
            assert (next == null || fieldValue.length == 0 || ByteUtil.compare((byte[])next, (byte[])fieldValue) <= 0);
            if (next == null) break;
            if (!Arrays.equals(next, fieldValue) || !decodeOK) {
                writer.write(next);
                break;
            }
            writer.write(fieldValue);
        }
        return writer.getBytes();
    }

    private boolean decodeValue(FieldType<?> fieldType, ByteReader reader) {
        try {
            fieldType.read(reader);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }
}

