/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.AbstractIndexView;
import io.permazen.core.FieldType;
import io.permazen.core.FieldTypesFilter;
import io.permazen.core.Index2View;
import io.permazen.core.IndexView;
import io.permazen.core.type.Tuple2FieldType;
import io.permazen.core.type.Tuple3FieldType;
import io.permazen.kv.KeyFilter;
import io.permazen.tuple.Tuple2;
import io.permazen.tuple.Tuple3;
import io.permazen.util.UnsignedIntEncoder;

class Index3View<V1, V2, V3, T>
extends AbstractIndexView {
    Index3View(int storageId, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<T> targetType) {
        this(UnsignedIntEncoder.encode((int)storageId), false, value1Type, value2Type, value3Type, targetType);
    }

    Index3View(byte[] prefix, boolean prefixMode, FieldType<V1> value1Type, FieldType<V2> value2Type, FieldType<V3> value3Type, FieldType<T> targetType) {
        super(prefix, prefixMode, value1Type, value2Type, value3Type, targetType);
    }

    private Index3View(Index3View<V1, V2, V3, T> original) {
        super(original);
    }

    public FieldType<V1> getValue1Type() {
        return this.fieldTypes[0];
    }

    public FieldType<V2> getValue2Type() {
        return this.fieldTypes[1];
    }

    public FieldType<V3> getValue3Type() {
        return this.fieldTypes[2];
    }

    public FieldType<T> getTargetType() {
        return this.fieldTypes[3];
    }

    @Override
    public Index3View<V1, V2, V3, T> filter(int index, KeyFilter keyFilter) {
        return (Index3View)super.filter(index, keyFilter);
    }

    @Override
    protected Index3View<V1, V2, V3, T> copy() {
        return new Index3View<V1, V2, V3, T>(this);
    }

    public IndexView<Tuple3<V1, V2, V3>, T> asTuple3IndexView() {
        AbstractIndexView indexView = new IndexView(this.prefix, this.prefixMode, new Tuple3FieldType<V1, V2, V3>(this.getValue1Type(), this.getValue2Type(), this.getValue3Type()), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter targetFilter = this.getFilter(3);
        if (value1Filter != null || value2Filter != null || value3Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type(), this.getValue3Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            if (value3Filter != null) {
                tupleFilter = tupleFilter.filter(2, value3Filter);
            }
            indexView = ((IndexView)indexView).filter(0, tupleFilter);
        }
        if (targetFilter != null) {
            indexView = ((IndexView)indexView).filter(1, targetFilter);
        }
        return indexView;
    }

    public Index2View<Tuple2<V1, V2>, V3, T> asTuple2Index2View() {
        AbstractIndexView indexView = new Index2View(this.prefix, this.prefixMode, new Tuple2FieldType<V1, V2>(this.getValue1Type(), this.getValue2Type()), this.getValue3Type(), this.getTargetType());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter targetFilter = this.getFilter(3);
        if (value1Filter != null || value2Filter != null) {
            FieldTypesFilter tupleFilter = new FieldTypesFilter(null, this.getValue1Type(), this.getValue2Type());
            if (value1Filter != null) {
                tupleFilter = tupleFilter.filter(0, value1Filter);
            }
            if (value2Filter != null) {
                tupleFilter = tupleFilter.filter(1, value2Filter);
            }
            indexView = ((Index2View)indexView).filter(0, tupleFilter);
        }
        if (value3Filter != null) {
            indexView = ((Index2View)indexView).filter(1, value3Filter);
        }
        if (targetFilter != null) {
            indexView = ((Index2View)indexView).filter(2, targetFilter);
        }
        return indexView;
    }

    public Index2View<V1, V2, V3> asIndex2View() {
        AbstractIndexView indexView = new Index2View<V1, V2, V3>(this.prefix, true, this.getValue1Type(), this.getValue2Type(), this.getValue3Type());
        KeyFilter value1Filter = this.getFilter(0);
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        if (value1Filter != null) {
            indexView = indexView.filter(0, value1Filter);
        }
        if (value2Filter != null) {
            indexView = indexView.filter(1, value2Filter);
        }
        if (value3Filter != null) {
            indexView = indexView.filter(2, value3Filter);
        }
        return indexView;
    }

    public Index2View<V2, V3, T> asIndex2View(byte[] keyPrefix) {
        AbstractIndexView indexView = new Index2View<V2, V3, T>(keyPrefix, this.prefixMode, this.getValue2Type(), this.getValue3Type(), this.getTargetType());
        KeyFilter value2Filter = this.getFilter(1);
        KeyFilter value3Filter = this.getFilter(2);
        KeyFilter targetFilter = this.getFilter(3);
        if (value2Filter != null) {
            indexView = indexView.filter(0, value2Filter);
        }
        if (value3Filter != null) {
            indexView = indexView.filter(1, value3Filter);
        }
        if (targetFilter != null) {
            indexView = indexView.filter(2, targetFilter);
        }
        return indexView;
    }
}

