/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.CoreIndex;
import io.permazen.core.CoreIndex2;
import io.permazen.core.CoreIndex3;
import io.permazen.core.FieldType;
import io.permazen.core.FieldTypeMap;
import io.permazen.core.Index2View;
import io.permazen.core.Index3View;
import io.permazen.core.Index4View;
import io.permazen.core.IndexKeyFilter;
import io.permazen.core.IndexSet;
import io.permazen.core.IndexView;
import io.permazen.index.Index;
import io.permazen.index.Index2;
import io.permazen.index.Index3;
import io.permazen.kv.KVPair;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.util.Bounds;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import java.util.NavigableMap;
import java.util.NavigableSet;

abstract class IndexMap<K, V>
extends FieldTypeMap<K, V> {
    private IndexMap(KVStore kv, FieldType<K> keyType, byte[] prefix) {
        super(kv, keyType, true, prefix);
    }

    private IndexMap(KVStore kv, FieldType<K> keyType, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<K> bounds) {
        super(kv, keyType, true, reversed, prefix, keyRange, keyFilter, bounds);
    }

    public String getDescription() {
        return "IndexMap[prefix=" + ByteUtil.toString((byte[])this.prefix) + ",keyType=" + this.keyFieldType + (this.bounds != null ? ",bounds=" + this.bounds : "") + (this.keyRange != null ? ",keyRange=" + this.keyRange : "") + (this.keyFilter != null ? ",keyFilter=" + this.keyFilter : "") + (this.reversed ? ",reversed" : "") + "]";
    }

    public IndexMap<K, V> filterKeys(KeyFilter keyFilter) {
        return (IndexMap)((Object)super.filterKeys(keyFilter));
    }

    protected V decodeValue(KVPair pair) {
        ByteReader reader = new ByteReader(pair.getKey());
        assert (ByteUtil.isPrefixOf((byte[])this.prefix, (byte[])reader.getBytes()));
        reader.skip(this.prefix.length);
        this.keyFieldType.skip(reader);
        return this.decodeValue(reader.getBytes(0, reader.getOffset()));
    }

    protected abstract V decodeValue(byte[] var1);

    static class OfIndex3<V1, V2, V3, V4, T>
    extends IndexMap<V1, Index3<V2, V3, V4, T>> {
        private final Index4View<V1, V2, V3, V4, T> indexView;

        OfIndex3(KVStore kv, Index4View<V1, V2, V3, V4, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex3(KVStore kv, Index4View<V1, V2, V3, V4, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index3<V2, V3, V4, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex3<V1, V2, V3, V4, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex3<V2, V3, V4, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex3<V2, V3, V4, T>(this.kv, this.indexView.asIndex3View(keyPrefix));
        }
    }

    static class OfIndex2<V1, V2, V3, T>
    extends IndexMap<V1, Index2<V2, V3, T>> {
        private final Index3View<V1, V2, V3, T> indexView;

        OfIndex2(KVStore kv, Index3View<V1, V2, V3, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex2(KVStore kv, Index3View<V1, V2, V3, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index2<V2, V3, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex2<V1, V2, V3, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex2<V2, V3, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex2<V2, V3, T>(this.kv, this.indexView.asIndex2View(keyPrefix));
        }
    }

    static class OfIndex<V1, V2, T>
    extends IndexMap<V1, Index<V2, T>> {
        private final Index2View<V1, V2, T> indexView;

        OfIndex(KVStore kv, Index2View<V1, V2, T> indexView) {
            super(kv, indexView.getValue1Type(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfIndex(KVStore kv, Index2View<V1, V2, T> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V1> bounds) {
            super(kv, indexView.getValue1Type(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V1, Index<V2, T>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V1> newBounds) {
            return new OfIndex<V1, V2, T>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected CoreIndex<V2, T> decodeValue(byte[] keyPrefix) {
            return new CoreIndex<V2, T>(this.kv, this.indexView.asIndexView(keyPrefix));
        }
    }

    static class OfValues<V, E>
    extends IndexMap<V, NavigableSet<E>> {
        private final IndexView<V, E> indexView;

        OfValues(KVStore kv, IndexView<V, E> indexView) {
            super(kv, indexView.getValueType(), indexView.prefix);
            this.indexView = indexView;
        }

        private OfValues(KVStore kv, IndexView<V, E> indexView, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<V> bounds) {
            super(kv, indexView.getValueType(), reversed, indexView.prefix, keyRange, keyFilter, bounds);
            this.indexView = indexView;
        }

        protected NavigableMap<V, NavigableSet<E>> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<V> newBounds) {
            return new OfValues<V, E>(this.kv, this.indexView, newReversed, newKeyRange, newKeyFilter, newBounds);
        }

        @Override
        protected NavigableSet<E> decodeValue(byte[] keyPrefix) {
            IndexSet<E> indexSet = new IndexSet<E>(this.kv, this.indexView.getTargetType(), this.indexView.prefixMode, keyPrefix);
            KeyFilter targetFilter = this.indexView.getFilter(1);
            if (targetFilter != null) {
                indexSet = indexSet.filterKeys(new IndexKeyFilter(this.kv, keyPrefix, new FieldType[]{this.indexView.getTargetType()}, new KeyFilter[]{targetFilter}, 1));
            }
            return indexSet;
        }
    }
}

