/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldChangeNotifier;
import io.permazen.core.FieldType;
import io.permazen.core.InconsistentDatabaseException;
import io.permazen.core.ListField;
import io.permazen.core.ListFieldChangeListener;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.Transaction;
import io.permazen.kv.KVPair;
import io.permazen.kv.KeyRange;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import io.permazen.util.CloseableIterator;
import io.permazen.util.UnsignedIntEncoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.stream.Collectors;

class JSList<E>
extends AbstractList<E>
implements RandomAccess {
    private final Transaction tx;
    private final ObjId id;
    private final ListField<E> field;
    private final FieldType<E> elementType;
    private final byte[] contentPrefix;

    JSList(Transaction tx, ListField<E> field, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"null field");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        this.tx = tx;
        this.field = field;
        this.id = id;
        this.elementType = this.field.elementField.fieldType;
        this.contentPrefix = field.buildKey(id);
    }

    @Override
    public E get(int index) {
        byte[] value = this.tx.kvt.get(this.buildKey(index));
        if (value == null) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        return this.elementType.read(new ByteReader(value));
    }

    @Override
    public int size() {
        KVPair pair = this.tx.kvt.getAtMost(ByteUtil.getKeyAfterPrefix((byte[])this.contentPrefix), this.contentPrefix);
        if (pair == null) {
            return 0;
        }
        assert (ByteUtil.isPrefixOf((byte[])this.contentPrefix, (byte[])pair.getKey()));
        return UnsignedIntEncoder.read((ByteReader)new ByteReader(pair.getKey(), this.contentPrefix.length)) + 1;
    }

    @Override
    public E set(int index, E elem) {
        return (E)this.tx.mutateAndNotify(this.id, () -> this.doSet(index, elem));
    }

    @Override
    public CloseableIterator<E> iterator() {
        return new Iter();
    }

    private E doSet(final int index, final E newElem) {
        byte[] key = this.buildKey(index);
        byte[] newValue = this.buildValue(newElem);
        byte[] oldValue = this.tx.kvt.get(key);
        if (oldValue == null) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        if (this.field.elementField instanceof ReferenceField) {
            this.tx.checkDeletedAssignment(this.id, (ReferenceField)this.field.elementField, (ObjId)newElem);
        }
        if (Arrays.equals(newValue, oldValue)) {
            return newElem;
        }
        final E oldElem = this.elementType.read(new ByteReader(oldValue));
        this.tx.kvt.put(key, newValue);
        if (this.field.elementField.indexed) {
            this.field.removeIndexEntry(this.tx, this.id, this.field.elementField, key, oldValue);
            this.field.addIndexEntry(this.tx, this.id, this.field.elementField, key, newValue);
        }
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new ListFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, ListFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onListFieldReplace(tx, this.id, JSList.this.field, path, referrers, index, oldElem, newElem);
                }
            });
        }
        return oldElem;
    }

    @Override
    public void add(int index, E elem) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        this.tx.mutateAndNotify(this.id, () -> this.doAddAll(index, Collections.singleton(elem)));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elems) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        return this.tx.mutateAndNotify(this.id, () -> this.doAddAll(index, elems));
    }

    private boolean doAddAll(int index, Collection<? extends E> elems0) {
        ArrayList<E> elems = new ArrayList<E>(elems0);
        int numElems = elems.size();
        if (this.field.elementField instanceof ReferenceField) {
            for (E elem : elems) {
                this.tx.checkDeletedAssignment(this.id, (ReferenceField)this.field.elementField, (ObjId)elem);
            }
        }
        ArrayList values = elems.stream().map(this::buildValue).collect(Collectors.toCollection(() -> new ArrayList(numElems)));
        int size = this.size();
        if (index < 0 || index > size || size + numElems == Integer.MAX_VALUE || size + numElems < 0) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + size);
        }
        this.shift(index, index + numElems, size);
        for (int i = 0; i < numElems; ++i) {
            byte[] key = this.buildKey(index);
            byte[] value = (byte[])values.get(i);
            final E elem = elems.get(i);
            this.tx.kvt.put(key, value);
            if (this.field.elementField.indexed) {
                this.field.addIndexEntry(this.tx, this.id, this.field.elementField, key, value);
            }
            if (!this.tx.disableListenerNotifications) {
                final int index2 = index;
                this.tx.addFieldChangeNotification(new ListFieldChangeNotifier(){

                    @Override
                    public void notify(Transaction tx, ListFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                        listener.onListFieldAdd(tx, this.id, JSList.this.field, path, referrers, index2, elem);
                    }
                });
            }
            ++index;
        }
        return numElems > 0;
    }

    @Override
    public void clear() {
        this.tx.mutateAndNotify(this.id, new Transaction.Mutation<Void>(){

            @Override
            public Void mutate() {
                JSList.this.doClear();
                return null;
            }
        });
    }

    private void doClear() {
        if (this.isEmpty()) {
            return;
        }
        if (this.field.elementField.indexed) {
            this.field.removeIndexEntries(this.tx, this.id, this.field.elementField);
        }
        this.field.deleteContent(this.tx, this.id);
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new ListFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, ListFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onListFieldClear(tx, this.id, JSList.this.field, path, referrers);
                }
            });
        }
    }

    @Override
    public E remove(int index) {
        E elem = this.get(index);
        this.removeRange(index, index + 1);
        return elem;
    }

    @Override
    protected void removeRange(final int min, final int max) {
        this.tx.mutateAndNotify(this.id, new Transaction.Mutation<Void>(){

            @Override
            public Void mutate() {
                JSList.this.doRemoveRange(min, max);
                return null;
            }
        });
    }

    private void doRemoveRange(int min, int max) {
        int size = this.size();
        if (min == 0 && max == size) {
            this.doClear();
            return;
        }
        if (min < 0 || max < min || max > size) {
            throw new IndexOutOfBoundsException("min = " + min + ", max = " + max + ", size = " + size);
        }
        if (this.field.elementField.indexed) {
            this.deleteIndexEntries(min, max);
        }
        if (!this.tx.disableListenerNotifications) {
            int i = min;
            while (i < max) {
                final byte[] value = this.tx.kvt.get(this.buildKey(i));
                if (value == null) {
                    throw new InconsistentDatabaseException("list entry at index " + i + " not found");
                }
                final int i2 = i++;
                this.tx.addFieldChangeNotification(new ListFieldChangeNotifier(){
                    private boolean decoded;
                    private E elem;

                    @Override
                    public void notify(Transaction tx, ListFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                        if (!this.decoded) {
                            this.elem = JSList.this.elementType.read(new ByteReader(value));
                            this.decoded = true;
                        }
                        listener.onListFieldRemove(tx, this.id, JSList.this.field, path, referrers, i2, this.elem);
                    }
                });
            }
        }
        this.shift(max, min, size);
    }

    private void shift(int from, int to, int size) {
        int step;
        int dst;
        int src;
        ++this.modCount;
        int len = size - from;
        if (to < from) {
            src = from;
            dst = to;
            step = 1;
        } else {
            src = from + len - 1;
            dst = to + len - 1;
            step = -1;
            len = size - from;
        }
        while (len-- > 0) {
            byte[] srcKey = this.buildKey(src);
            byte[] value = this.tx.kvt.get(srcKey);
            if (value == null) {
                throw new InconsistentDatabaseException("list entry at index " + src + " not found");
            }
            if (this.field.elementField.indexed) {
                this.field.removeIndexEntry(this.tx, this.id, this.field.elementField, srcKey, value);
            }
            byte[] dstKey = this.buildKey(dst);
            this.tx.kvt.put(dstKey, value);
            if (this.field.elementField.indexed) {
                this.field.addIndexEntry(this.tx, this.id, this.field.elementField, dstKey, value);
            }
            src += step;
            dst += step;
        }
        if (to < from) {
            int newSize = size - (from - to);
            byte[] minKey = this.buildKey(newSize);
            byte[] maxKey = ByteUtil.getKeyAfterPrefix((byte[])this.contentPrefix);
            this.tx.kvt.removeRange(minKey, maxKey);
        }
    }

    private void deleteIndexEntries(int min, int max) {
        assert (this.field.elementField.indexed);
        for (int i = min; i < max; ++i) {
            byte[] key = this.buildKey(i);
            byte[] value = this.tx.kvt.get(key);
            if (value == null) {
                throw new InconsistentDatabaseException("list entry at index " + i + " not found");
            }
            this.field.removeIndexEntry(this.tx, this.id, this.field.elementField, key, value);
        }
    }

    private byte[] buildKey(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        ByteWriter writer = new ByteWriter();
        writer.write(this.contentPrefix);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)index);
        return writer.getBytes();
    }

    private byte[] buildValue(E elem) {
        ByteWriter writer = new ByteWriter();
        try {
            this.elementType.validateAndWrite(writer, elem);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("list containing " + this.elementType + " can't hold values of type " + (elem != null ? elem.getClass().getName() : "null"), e);
        }
        return writer.getBytes();
    }

    private abstract class ListFieldChangeNotifier
    extends FieldChangeNotifier<ListFieldChangeListener> {
        ListFieldChangeNotifier() {
            super(ListFieldChangeListener.class, ((JSList)JSList.this).field.storageId, JSList.this.id);
        }
    }

    private class Iter
    implements CloseableIterator<E> {
        private CloseableIterator<KVPair> i;
        private boolean finished;
        private Integer removeIndex;

        Iter() {
            this.i = ((JSList)JSList.this).tx.kvt.getRange(KeyRange.forPrefix((byte[])JSList.this.contentPrefix));
        }

        public void close() {
            this.i.close();
        }

        public synchronized boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (!this.i.hasNext()) {
                this.finished = true;
                this.i.close();
                return false;
            }
            return true;
        }

        public synchronized E next() {
            if (this.finished) {
                throw new NoSuchElementException();
            }
            KVPair pair = (KVPair)this.i.next();
            ByteReader keyReader = new ByteReader(pair.getKey());
            keyReader.skip(JSList.this.contentPrefix.length);
            this.removeIndex = UnsignedIntEncoder.read((ByteReader)keyReader);
            return JSList.this.elementType.read(new ByteReader(pair.getValue()));
        }

        public synchronized void remove() {
            Preconditions.checkState((this.removeIndex != null ? 1 : 0) != 0);
            JSList.this.removeRange(this.removeIndex, this.removeIndex + 1);
            this.removeIndex = null;
        }
    }
}

