/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldChangeNotifier;
import io.permazen.core.FieldTypeMap;
import io.permazen.core.MapField;
import io.permazen.core.MapFieldChangeListener;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.Transaction;
import io.permazen.kv.KVPair;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.util.Bounds;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;

class JSMap<K, V>
extends FieldTypeMap<K, V> {
    private final Transaction tx;
    private final ObjId id;
    private final MapField<K, V> field;

    JSMap(Transaction tx, MapField<K, V> field, ObjId id) {
        super((KVStore)tx.kvt, field.keyField.fieldType, false, field.buildKey(id));
        this.tx = tx;
        this.id = id;
        this.field = field;
    }

    private JSMap(Transaction tx, MapField<K, V> field, ObjId id, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<K> bounds) {
        super((KVStore)tx.kvt, field.keyField.fieldType, false, reversed, field.buildKey(id), keyRange, keyFilter, bounds);
        Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"null keyRange");
        this.tx = tx;
        this.id = id;
        this.field = field;
    }

    public V put(K keyObj, V valueObj) {
        byte[] value;
        byte[] key;
        try {
            key = this.encodeVisibleKey(keyObj, true);
            value = this.encodeValue(valueObj);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("can't add invalid key/value pair to " + this.field + ": " + e.getMessage(), e);
        }
        return (V)this.tx.mutateAndNotify(this.id, () -> this.doPut(keyObj, valueObj, key, value));
    }

    private V doPut(final K keyObj, final V newValueObj, byte[] key, byte[] newValue) {
        V oldValueObj;
        byte[] oldValue;
        if (this.field.keyField instanceof ReferenceField) {
            this.tx.checkDeletedAssignment(this.id, (ReferenceField)this.field.keyField, (ObjId)keyObj);
        }
        if (this.field.valueField instanceof ReferenceField) {
            this.tx.checkDeletedAssignment(this.id, (ReferenceField)this.field.valueField, (ObjId)newValueObj);
        }
        if ((oldValue = this.tx.kvt.get(key)) != null) {
            oldValueObj = this.decodeValue(new KVPair(key, oldValue));
            if (Arrays.equals(newValue, oldValue)) {
                return oldValueObj;
            }
            if (this.field.keyField.indexed) {
                this.field.removeIndexEntry(this.tx, this.id, this.field.keyField, key, oldValue);
            }
            if (this.field.valueField.indexed) {
                this.field.removeIndexEntry(this.tx, this.id, this.field.valueField, key, oldValue);
            }
        } else {
            oldValueObj = null;
        }
        this.tx.kvt.put(key, newValue);
        if (this.field.keyField.indexed) {
            this.field.addIndexEntry(this.tx, this.id, this.field.keyField, key, newValue);
        }
        if (this.field.valueField.indexed) {
            this.field.addIndexEntry(this.tx, this.id, this.field.valueField, key, newValue);
        }
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new MapFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, MapFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    if (oldValue == null) {
                        listener.onMapFieldAdd(tx, this.id, JSMap.this.field, path, referrers, keyObj, newValueObj);
                    } else {
                        listener.onMapFieldReplace(tx, this.id, JSMap.this.field, path, referrers, keyObj, oldValueObj, newValueObj);
                    }
                }
            });
        }
        return oldValueObj;
    }

    public V remove(Object keyObj) {
        byte[] key = this.encodeVisibleKey(keyObj, false);
        if (key == null) {
            return null;
        }
        Object canonicalKey = this.keyFieldType.validate(keyObj);
        return (V)this.tx.mutateAndNotify(this.id, () -> this.doRemove(canonicalKey, key));
    }

    private V doRemove(final K keyObj, byte[] key) {
        byte[] oldValue = this.tx.kvt.get(key);
        if (oldValue == null) {
            return null;
        }
        final V valueObj = this.decodeValue(new KVPair(key, oldValue));
        this.tx.kvt.remove(key);
        if (this.field.keyField.indexed) {
            this.field.removeIndexEntry(this.tx, this.id, this.field.keyField, key, oldValue);
        }
        if (this.field.valueField.indexed) {
            this.field.removeIndexEntry(this.tx, this.id, this.field.valueField, key, oldValue);
        }
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new MapFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, MapFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onMapFieldRemove(tx, this.id, JSMap.this.field, path, referrers, keyObj, valueObj);
                }
            });
        }
        return valueObj;
    }

    public void clear() {
        if (this.keyFilter != null) {
            throw new UnsupportedOperationException("clear() not supported when KeyFilter configured");
        }
        this.tx.mutateAndNotify(this.id, new Transaction.Mutation<Void>(){

            @Override
            public Void mutate() {
                JSMap.this.doClear();
                return null;
            }
        });
    }

    private void doClear() {
        if (this.isEmpty()) {
            return;
        }
        if (!this.bounds.equals((Object)new Bounds()) && this.tx.hasFieldMonitor(this.id, this.field.storageId)) {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            return;
        }
        byte[] rangeMinKey = this.keyRange.getMin();
        byte[] rangeMaxKey = this.keyRange.getMax();
        if (this.field.keyField.indexed) {
            this.field.removeIndexEntries(this.tx, this.id, this.field.keyField, rangeMinKey, rangeMaxKey);
        }
        if (this.field.valueField.indexed) {
            this.field.removeIndexEntries(this.tx, this.id, this.field.valueField, rangeMinKey, rangeMaxKey);
        }
        this.field.deleteContent(this.tx, rangeMinKey, rangeMaxKey);
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new MapFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, MapFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onMapFieldClear(tx, this.id, JSMap.this.field, path, referrers);
                }
            });
        }
    }

    protected NavigableMap<K, V> createSubMap(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<K> newBounds) {
        return new JSMap<K, V>(this.tx, this.field, this.id, newReversed, newKeyRange, newKeyFilter, newBounds);
    }

    private byte[] encodeValue(Object obj) {
        ByteWriter writer = new ByteWriter();
        this.field.valueField.fieldType.validateAndWrite(writer, obj);
        return writer.getBytes();
    }

    protected V decodeValue(KVPair pair) {
        return (V)this.field.valueField.fieldType.read(new ByteReader(pair.getValue()));
    }

    private abstract class MapFieldChangeNotifier
    extends FieldChangeNotifier<MapFieldChangeListener> {
        MapFieldChangeNotifier() {
            super(MapFieldChangeListener.class, ((JSMap)JSMap.this).field.storageId, JSMap.this.id);
        }
    }
}

