/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.FieldChangeNotifier;
import io.permazen.core.FieldTypeSet;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.SetField;
import io.permazen.core.SetFieldChangeListener;
import io.permazen.core.Transaction;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.util.Bounds;
import io.permazen.util.ByteUtil;
import io.permazen.util.CloseableIterator;
import java.util.NavigableSet;

class JSSet<E>
extends FieldTypeSet<E> {
    private final Transaction tx;
    private final ObjId id;
    private final SetField<E> field;

    JSSet(Transaction tx, SetField<E> field, ObjId id) {
        super((KVStore)tx.kvt, field.elementField.fieldType, false, field.buildKey(id));
        this.tx = tx;
        this.id = id;
        this.field = field;
    }

    private JSSet(Transaction tx, SetField<E> field, ObjId id, boolean reversed, KeyRange keyRange, KeyFilter keyFilter, Bounds<E> bounds) {
        super((KVStore)tx.kvt, field.elementField.fieldType, false, reversed, field.buildKey(id), keyRange, keyFilter, bounds);
        Preconditions.checkArgument((keyRange != null ? 1 : 0) != 0, (Object)"null keyRange");
        this.tx = tx;
        this.id = id;
        this.field = field;
    }

    public boolean add(E newValue) {
        byte[] key;
        try {
            key = this.encodeVisible(newValue, true);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("can't add invalid value to " + this.field + ": " + e.getMessage(), e);
        }
        return this.tx.mutateAndNotify(this.id, () -> this.doAdd(newValue, key));
    }

    private boolean doAdd(final E newValue, byte[] key) {
        if (this.field.elementField instanceof ReferenceField) {
            this.tx.checkDeletedAssignment(this.id, (ReferenceField)this.field.elementField, (ObjId)newValue);
        }
        if (this.tx.kvt.get(key) != null) {
            return false;
        }
        this.tx.kvt.put(key, ByteUtil.EMPTY);
        if (this.field.elementField.indexed) {
            this.field.addIndexEntry(this.tx, this.id, this.field.elementField, key, null);
        }
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new SetFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, SetFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onSetFieldAdd(tx, this.id, JSSet.this.field, path, referrers, newValue);
                }
            });
        }
        return true;
    }

    public void clear() {
        if (this.keyFilter != null) {
            throw new UnsupportedOperationException("clear() not supported when KeyFilter configured");
        }
        this.tx.mutateAndNotify(this.id, new Transaction.Mutation<Void>(){

            @Override
            public Void mutate() {
                JSSet.this.doClear();
                return null;
            }
        });
    }

    private void doClear() {
        if (this.isEmpty()) {
            return;
        }
        if (!this.bounds.equals((Object)new Bounds()) && this.tx.hasFieldMonitor(this.id, this.field.storageId)) {
            CloseableIterator i = this.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            return;
        }
        byte[] rangeMinKey = this.keyRange.getMin();
        byte[] rangeMaxKey = this.keyRange.getMax();
        if (this.field.elementField.indexed) {
            this.field.removeIndexEntries(this.tx, this.id, this.field.elementField, rangeMinKey, rangeMaxKey);
        }
        this.field.deleteContent(this.tx, rangeMinKey, rangeMaxKey);
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new SetFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, SetFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onSetFieldClear(tx, this.id, JSSet.this.field, path, referrers);
                }
            });
        }
    }

    public boolean remove(Object obj) {
        byte[] key = this.encodeVisible(obj, false);
        if (key == null) {
            return false;
        }
        Object canonicalElement = this.fieldType.validate(obj);
        return this.tx.mutateAndNotify(this.id, () -> this.doRemove(canonicalElement, key));
    }

    private boolean doRemove(final E oldValue, byte[] key) {
        if (this.tx.kvt.get(key) == null) {
            return false;
        }
        this.tx.kvt.remove(key);
        if (this.field.elementField.indexed) {
            this.field.removeIndexEntry(this.tx, this.id, this.field.elementField, key, null);
        }
        if (!this.tx.disableListenerNotifications) {
            this.tx.addFieldChangeNotification(new SetFieldChangeNotifier(){

                @Override
                public void notify(Transaction tx, SetFieldChangeListener listener, int[] path, NavigableSet<ObjId> referrers) {
                    listener.onSetFieldRemove(tx, this.id, JSSet.this.field, path, referrers, oldValue);
                }
            });
        }
        return true;
    }

    protected NavigableSet<E> createSubSet(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<E> newBounds) {
        return new JSSet<E>(this.tx, this.field, this.id, newReversed, newKeyRange, newKeyFilter, newBounds);
    }

    private abstract class SetFieldChangeNotifier
    extends FieldChangeNotifier<SetFieldChangeListener> {
        SetFieldChangeNotifier() {
            super(SetFieldChangeListener.class, ((JSSet)JSSet.this).field.storageId, JSSet.this.id);
        }
    }
}

