/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import io.permazen.core.CoreIndex;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.IndexView;
import io.permazen.core.InvalidSchemaException;
import io.permazen.core.ObjId;
import io.permazen.kv.KVPair;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyRange;
import io.permazen.schema.SchemaModel;
import io.permazen.util.ByteWriter;
import io.permazen.util.CloseableIterator;
import io.permazen.util.UnsignedIntEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class Layout {
    public static final int FORMAT_VERSION_1 = 1;
    public static final int FORMAT_VERSION_2 = 2;
    public static final int CURRENT_FORMAT_VERSION = 2;
    private static final byte METADATA_PREFIX_BYTE = 0;
    private static final byte[] METADATA_PREFIX = new byte[]{0};
    private static final byte[] FORMAT_VERSION_KEY = new byte[]{0, 0, 74, 83, 105, 109, 112, 108, 101, 68, 66};
    private static final byte[] SCHEMA_KEY_PREFIX = new byte[]{0, 1};
    private static final byte[] VERSION_INDEX_PREFIX = new byte[]{0, -128};
    private static final byte[] USER_META_DATA_KEY_PREFIX = new byte[]{0, -1};
    private static final byte[] SCHEMA_XML_COMPRESSION_DICTIONARY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Schema formatVersion=\"2<CompositeIndex<Counter<Enum<Identifier<Indexed<List<Map<ObjectType<ReferenceField<SetField<SimpleField storageId=\" cascadeDelete=\" encodingSignature=\" indexed=\" name=\" onDelete=\" type=\"booleanbyte[]shortcharintegerfloatlongdoublejava.lang.Stringutil.DateUUIDURIio.Fileregex.PatterntruefalseNOTHINGEXCEPTIONUNREFERENCEDELETE\"><".getBytes(StandardCharsets.UTF_8);

    private Layout() {
    }

    public static byte[] getMetaDataKeyPrefix() {
        return (byte[])METADATA_PREFIX.clone();
    }

    public static KeyRange getMetaDataKeyRange() {
        return KeyRange.forPrefix((byte[])METADATA_PREFIX);
    }

    public static byte[] getFormatVersionKey() {
        return (byte[])FORMAT_VERSION_KEY.clone();
    }

    public static byte[] getSchemaKeyPrefix() {
        return (byte[])SCHEMA_KEY_PREFIX.clone();
    }

    public static KeyRange getSchemaKeyRange() {
        return KeyRange.forPrefix((byte[])SCHEMA_KEY_PREFIX);
    }

    public static byte[] buildSchemaKey(int version) {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"version <= 0");
        ByteWriter writer = new ByteWriter(VERSION_INDEX_PREFIX.length + UnsignedIntEncoder.encodeLength((int)version));
        writer.write(SCHEMA_KEY_PREFIX);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        return writer.getBytes();
    }

    public static byte[] getObjectVersionIndexKeyPrefix() {
        return (byte[])VERSION_INDEX_PREFIX.clone();
    }

    public static byte[] getUserMetaDataKeyPrefix() {
        return (byte[])USER_META_DATA_KEY_PREFIX.clone();
    }

    public static CoreIndex<Integer, ObjId> getVersionIndex(KVStore kv) {
        Preconditions.checkArgument((kv != null ? 1 : 0) != 0, (Object)"null kv");
        return new CoreIndex<Integer, ObjId>(kv, new IndexView<Integer, ObjId>(VERSION_INDEX_PREFIX, false, FieldTypeRegistry.UNSIGNED_INT, FieldTypeRegistry.OBJ_ID));
    }

    public static byte[] buildVersionIndexKey(ObjId id, int version) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"non-positive version");
        ByteWriter writer = new ByteWriter(VERSION_INDEX_PREFIX.length + 5 + 8);
        writer.write(VERSION_INDEX_PREFIX);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        id.writeTo(writer);
        return writer.getBytes();
    }

    public static SchemaModel decodeSchema(byte[] value, int formatVersion) {
        boolean compressed;
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        switch (formatVersion) {
            case 1: 
            case 2: {
                compressed = formatVersion >= 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized format version " + formatVersion);
            }
        }
        if (compressed) {
            try {
                int r;
                Inflater inflater = new Inflater(true);
                inflater.setDictionary(SCHEMA_XML_COMPRESSION_DICTIONARY);
                inflater.setInput(Bytes.concat((byte[][])new byte[][]{value, new byte[1]}));
                ByteArrayOutputStream decompressed = new ByteArrayOutputStream();
                byte[] temp = new byte[1000];
                while ((r = inflater.inflate(temp)) != 0) {
                    decompressed.write(temp, 0, r);
                }
                if (!inflater.finished()) {
                    throw new RuntimeException("internal error: inflater did not finish");
                }
                inflater.end();
                value = decompressed.toByteArray();
            }
            catch (DataFormatException e) {
                throw new InvalidSchemaException("error in compressed schema XML data", e);
            }
        }
        try {
            return SchemaModel.fromXML(new ByteArrayInputStream(value));
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public static byte[] encodeSchema(SchemaModel schemaModel, int formatVersion) {
        boolean compress;
        Preconditions.checkArgument((schemaModel != null ? 1 : 0) != 0, (Object)"null schemaModel");
        switch (formatVersion) {
            case 1: 
            case 2: {
                compress = formatVersion >= 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized format version " + formatVersion);
            }
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            schemaModel.toXML(buf, false);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        byte[] value = buf.toByteArray();
        if (compress) {
            int r;
            Deflater deflater = new Deflater(9, true);
            deflater.setDictionary(SCHEMA_XML_COMPRESSION_DICTIONARY);
            deflater.setInput(value);
            deflater.finish();
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            byte[] temp = new byte[1000];
            while ((r = deflater.deflate(temp)) != 0) {
                compressed.write(temp, 0, r);
            }
            if (!deflater.finished()) {
                throw new RuntimeException("internal error: deflater did not finish");
            }
            deflater.end();
            value = compressed.toByteArray();
        }
        return value;
    }

    public static byte[] getSchemaKey(int version) {
        Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"non-positive version");
        ByteWriter writer = new ByteWriter(SCHEMA_KEY_PREFIX.length + 5);
        writer.write(SCHEMA_KEY_PREFIX);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        return writer.getBytes();
    }

    public static void deleteObjectData(KVStore kv) {
        KeyRange metaDataRange = KeyRange.forPrefix((byte[])Layout.getMetaDataKeyPrefix());
        KeyRange versionIndexRange = KeyRange.forPrefix((byte[])Layout.getObjectVersionIndexKeyPrefix());
        assert (metaDataRange.contains(versionIndexRange));
        kv.removeRange(null, metaDataRange.getMin());
        kv.removeRange(metaDataRange.getMax(), null);
        kv.removeRange(metaDataRange.getMin(), versionIndexRange.getMin());
        kv.removeRange(versionIndexRange.getMax(), metaDataRange.getMax());
    }

    public static void copyMetaData(KVStore src, KVStore dst) {
        KeyRange metaDataRange = KeyRange.forPrefix((byte[])Layout.getMetaDataKeyPrefix());
        KeyRange versionIndexRange = KeyRange.forPrefix((byte[])Layout.getObjectVersionIndexKeyPrefix());
        assert (metaDataRange.contains(versionIndexRange));
        Layout.copyRange(src, dst, metaDataRange.getMin(), versionIndexRange.getMin());
        Layout.copyRange(src, dst, versionIndexRange.getMax(), metaDataRange.getMax());
    }

    private static void copyRange(KVStore src, KVStore dst, byte[] minKey, byte[] maxKey) {
        try (CloseableIterator i = src.getRange(minKey, maxKey);){
            while (i.hasNext()) {
                KVPair pair = (KVPair)i.next();
                dst.put(pair.getKey(), pair.getValue());
            }
        }
    }
}

