/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.CollectionElementStorageInfo;
import io.permazen.core.CoreIndex;
import io.permazen.core.CoreIndex2;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.Index2View;
import io.permazen.core.ListField;
import io.permazen.core.ObjId;
import io.permazen.core.Transaction;
import io.permazen.kv.KVPairIterator;
import io.permazen.kv.KVStore;
import io.permazen.util.ByteReader;
import io.permazen.util.UnsignedIntEncoder;
import java.util.List;

class ListElementStorageInfo<E>
extends CollectionElementStorageInfo<List<E>, E, ListField<E>> {
    ListElementStorageInfo(ListField<E> field) {
        super(field);
    }

    CoreIndex2<E, ObjId, Integer> getElementIndex(Transaction tx) {
        return new CoreIndex2((KVStore)tx.kvt, new Index2View(this.storageId, this.fieldType, FieldTypeRegistry.OBJ_ID, FieldTypeRegistry.UNSIGNED_INT));
    }

    @Override
    CoreIndex<E, ObjId> getIndex(Transaction tx) {
        return this.getElementIndex(tx).asIndex();
    }

    @Override
    void unreference(Transaction tx, ObjId target, ObjId referrer, byte[] prefix) {
        List<?> list = tx.readListField(referrer, ((ListField)this.parentRepresentative).storageId, false);
        KVPairIterator i = new KVPairIterator((KVStore)tx.kvt, prefix);
        while (i.hasNext()) {
            ByteReader reader = new ByteReader(i.next().getKey());
            reader.skip(prefix.length);
            list.remove(UnsignedIntEncoder.read((ByteReader)reader));
        }
    }

    @Override
    public String toString() {
        return "list element with " + this.fieldType;
    }
}

