/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.permazen.core.CollectionField;
import io.permazen.core.FieldSwitch;
import io.permazen.core.JSList;
import io.permazen.core.ListElementStorageInfo;
import io.permazen.core.ObjId;
import io.permazen.core.Schema;
import io.permazen.core.SimpleField;
import io.permazen.core.Transaction;
import io.permazen.core.util.ObjIdMap;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListField<E>
extends CollectionField<List<E>, E> {
    ListField(String name, int storageId, Schema schema, SimpleField<E> elementField) {
        super(name, storageId, schema, new TypeToken<List<E>>(){}.where(new TypeParameter<E>(){}, elementField.typeToken.wrap()), elementField);
    }

    @Override
    public List<E> getValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        return tx.readListField(id, this.storageId, false);
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseListField(this);
    }

    @Override
    public String toString() {
        return "list field `" + this.name + "' containing " + this.elementField;
    }

    @Override
    List<E> getValueInternal(Transaction tx, ObjId id) {
        return new JSList(tx, this, id);
    }

    @Override
    List<E> getValueReadOnlyCopy(Transaction tx, ObjId id) {
        return Collections.unmodifiableList(new ArrayList(this.getValueInternal(tx, id)));
    }

    ListElementStorageInfo<E> toStorageInfo(SimpleField<?> subField) {
        assert (subField == this.elementField);
        return new ListElementStorageInfo(this);
    }

    @Override
    void copy(ObjId srcId, ObjId dstId, Transaction srcTx, Transaction dstTx, ObjIdMap<ObjId> objectIdMap) {
        Collection srcList = this.getValue(srcTx, srcId);
        Collection dstList = this.getValue(dstTx, dstId);
        int ssize = srcList.size();
        int dsize = dstList.size();
        int min = Math.min(ssize, dsize);
        for (int i = 0; i < min; ++i) {
            dstList.set(i, this.elementField.remapObjectId(objectIdMap, srcList.get(i)));
        }
        if (ssize < dsize) {
            dstList.subList(ssize, dsize).clear();
        } else if (dsize < ssize) {
            for (Object elem : srcList.subList(dsize, ssize)) {
                dstList.add(this.elementField.remapObjectId(objectIdMap, elem));
            }
        }
    }

    @Override
    void buildIndexEntry(ObjId id, SimpleField<?> subField, ByteReader reader, byte[] value, ByteWriter writer) {
        assert (subField == this.elementField);
        writer.write(value);
        id.writeTo(writer);
        writer.write(reader);
    }
}

