/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.permazen.core.ComplexField;
import io.permazen.core.ComplexSubFieldStorageInfo;
import io.permazen.core.Field;
import io.permazen.core.FieldSwitch;
import io.permazen.core.FieldType;
import io.permazen.core.JSMap;
import io.permazen.core.MapKeyStorageInfo;
import io.permazen.core.MapValueStorageInfo;
import io.permazen.core.ObjId;
import io.permazen.core.ReferenceField;
import io.permazen.core.Schema;
import io.permazen.core.SimpleField;
import io.permazen.core.Transaction;
import io.permazen.core.util.ObjIdMap;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class MapField<K, V>
extends ComplexField<NavigableMap<K, V>> {
    public static final String KEY_FIELD_NAME = "key";
    public static final String VALUE_FIELD_NAME = "value";
    final SimpleField<K> keyField;
    final SimpleField<V> valueField;

    MapField(String name, int storageId, Schema schema, SimpleField<K> keyField, SimpleField<V> valueField) {
        super(name, storageId, schema, new TypeToken<NavigableMap<K, V>>(){}.where(new TypeParameter<K>(){}, keyField.typeToken.wrap()).where(new TypeParameter<V>(){}, valueField.typeToken.wrap()));
        this.keyField = keyField;
        this.valueField = valueField;
        assert (this.keyField.parent == null);
        assert (this.valueField.parent == null);
        this.keyField.parent = this;
        this.valueField.parent = this;
    }

    public SimpleField<K> getKeyField() {
        return this.keyField;
    }

    public SimpleField<V> getValueField() {
        return this.valueField;
    }

    @Override
    public List<SimpleField<?>> getSubFields() {
        ArrayList list = new ArrayList(2);
        list.add(this.keyField);
        list.add(this.valueField);
        return list;
    }

    @Override
    public NavigableMap<K, V> getValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        return tx.readMapField(id, this.storageId, false);
    }

    @Override
    public boolean hasDefaultValue(Transaction tx, ObjId id) {
        return this.getValue(tx, id).isEmpty();
    }

    @Override
    public String toString() {
        return "map field `" + this.name + "' containing key " + this.keyField.fieldType + " and value " + this.valueField.fieldType;
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseMapField(this);
    }

    @Override
    <F> Iterable<F> iterateSubField(Transaction tx, ObjId id, SimpleField<F> subField) {
        if (subField == this.keyField) {
            return this.getValue(tx, id).keySet();
        }
        if (subField == this.valueField) {
            return this.getValue(tx, id).values();
        }
        throw new IllegalArgumentException("unknown sub-field");
    }

    @Override
    NavigableMap<K, V> getValueInternal(Transaction tx, ObjId id) {
        return new JSMap(tx, this, id);
    }

    @Override
    NavigableMap<K, V> getValueReadOnlyCopy(Transaction tx, ObjId id) {
        return Maps.unmodifiableNavigableMap(new TreeMap(this.getValueInternal(tx, id)));
    }

    @Override
    ComplexSubFieldStorageInfo<?, ?> toStorageInfo(SimpleField<?> subField) {
        if (subField == this.keyField) {
            return new MapKeyStorageInfo(this);
        }
        if (subField == this.valueField) {
            return new MapValueStorageInfo(this);
        }
        throw new IllegalArgumentException("unknown sub-field");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void copy(ObjId srcId, ObjId dstId, Transaction srcTx, Transaction dstTx, ObjIdMap<ObjId> objectIdMap) {
        Map.Entry d;
        Map.Entry s;
        CloseableIterator di;
        CloseableIterator si;
        Object dst;
        Object src;
        FieldType keyFieldType;
        block60: {
            keyFieldType = this.keyField.fieldType;
            src = this.getValue(srcTx, srcId);
            dst = this.getValue(dstTx, dstId);
            si = CloseableIterator.wrap(src.entrySet().iterator());
            Throwable throwable = null;
            try {
                di = CloseableIterator.wrap(dst.entrySet().iterator());
                Throwable throwable2 = null;
                try {
                    if (!si.hasNext()) {
                        dst.clear();
                        return;
                    }
                    if (objectIdMap == null || objectIdMap.isEmpty() || !this.keyField.remapsObjectId() && !this.valueField.remapsObjectId()) {
                        if (!di.hasNext()) {
                            dst.putAll(src);
                            return;
                        }
                        s = (Map.Entry)si.next();
                        d = (Map.Entry)di.next();
                        break block60;
                    }
                    dst.clear();
                    while (si.hasNext()) {
                        Map.Entry entry = (Map.Entry)si.next();
                        K destKey = this.keyField.remapObjectId(objectIdMap, entry.getKey());
                        V destValue = this.valueField.remapObjectId(objectIdMap, entry.getValue());
                        dst.put(destKey, destValue);
                    }
                    return;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (di != null) {
                        if (throwable2 != null) {
                            try {
                                di.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            di.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (si != null) {
                    if (throwable != null) {
                        try {
                            si.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        si.close();
                    }
                }
            }
        }
        while (true) {
            int diff = keyFieldType.compare(s.getKey(), d.getKey());
            boolean sadvance = true;
            boolean dadvance = true;
            if (diff < 0) {
                dst.put(s.getKey(), s.getValue());
                dadvance = false;
            } else if (diff > 0) {
                di.remove();
                sadvance = false;
            } else {
                d.setValue(s.getValue());
            }
            if (sadvance) {
                if (!si.hasNext()) {
                    dst.tailMap(s.getKey(), false).clear();
                    return;
                }
                s = (Map.Entry)si.next();
            }
            if (!dadvance) continue;
            if (!di.hasNext()) {
                dst.putAll(src.tailMap(s.getKey(), true));
                return;
            }
            d = (Map.Entry)di.next();
        }
    }

    @Override
    void buildIndexEntry(ObjId id, SimpleField<?> subField, ByteReader reader, byte[] value, ByteWriter writer) {
        if (subField == this.keyField) {
            writer.write(reader);
            id.writeTo(writer);
        } else if (subField == this.valueField) {
            writer.write(value);
            id.writeTo(writer);
            writer.write(reader);
        } else {
            throw new RuntimeException("internal error");
        }
    }

    @Override
    void unreferenceRemovedTypes(Transaction tx, ObjId id, ReferenceField subField, SortedSet<Integer> removedStorageIds) {
        assert (subField == this.keyField || subField == this.valueField);
        Iterator i = this.getValueInternal(tx, id).entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ObjId ref = subField == this.keyField ? (ObjId)entry.getKey() : (ObjId)entry.getValue();
            if (ref == null || !removedStorageIds.contains(ref.getStorageId())) continue;
            i.remove();
        }
    }

    @Override
    boolean isUpgradeCompatible(Field<?> field) {
        if (field.getClass() != this.getClass()) {
            return false;
        }
        MapField that = (MapField)field;
        return this.keyField.isUpgradeCompatible(that.keyField) && this.valueField.isUpgradeCompatible(that.valueField);
    }
}

