/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.DeletedObjectException;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.InconsistentDatabaseException;
import io.permazen.core.InvalidObjectVersionException;
import io.permazen.core.ObjId;
import io.permazen.core.ObjType;
import io.permazen.core.Schema;
import io.permazen.core.Transaction;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.UnsignedIntEncoder;

class ObjInfo {
    private static final int META_DATA_VERSION = 1;
    final Transaction tx;
    final ObjId id;
    final int version;
    final boolean deleteNotified;
    Schema schema;
    ObjType objType;

    ObjInfo(Transaction tx, ObjId id) {
        assert (tx != null);
        assert (id != null);
        this.tx = tx;
        this.id = id;
        byte[] value = tx.kvt.get(this.id.getBytes());
        if (value == null) {
            throw new DeletedObjectException(tx, this.id);
        }
        ByteReader reader = new ByteReader(value);
        int metaDataVersion = UnsignedIntEncoder.read((ByteReader)reader);
        if (metaDataVersion != 1) {
            throw new InconsistentDatabaseException("found unknown object meta-data version " + metaDataVersion + " in " + this.id);
        }
        this.version = UnsignedIntEncoder.read((ByteReader)reader);
        if (this.version == 0) {
            throw new InvalidObjectVersionException(this.id, this.version);
        }
        this.deleteNotified = FieldTypeRegistry.BOOLEAN.read(reader);
    }

    ObjInfo(Transaction tx, ObjId id, int version, boolean deleteNotified, Schema schema, ObjType objType) {
        assert (tx != null);
        assert (id != null);
        this.tx = tx;
        this.id = id;
        this.version = version;
        this.deleteNotified = deleteNotified;
        this.schema = schema;
        this.objType = objType;
    }

    public ObjId getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDeleteNotified() {
        return this.deleteNotified;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            try {
                this.schema = this.tx.schemas.getVersion(this.version);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidObjectVersionException(this.id, this.version);
            }
        }
        return this.schema;
    }

    public ObjType getObjType() {
        if (this.objType == null) {
            try {
                this.objType = this.getSchema().getObjType(this.id.getStorageId());
            }
            catch (IllegalArgumentException e) {
                throw new InconsistentDatabaseException("object " + this.id + " has invalid storage ID", e);
            }
        }
        return this.objType;
    }

    public static void write(Transaction tx, ObjId id, int version, boolean deleteNotified) {
        ByteWriter writer = new ByteWriter();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)1);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        FieldTypeRegistry.BOOLEAN.write(writer, deleteNotified);
        tx.kvt.put(id.getBytes(), writer.getBytes());
    }

    public String toString() {
        return "ObjInfo[id=" + this.id + ",version=" + this.version + (this.deleteNotified ? ",deleteNotified" : "") + ",schema=" + this.schema + ",objType=" + this.objType + "]";
    }
}

