/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.permazen.core.ComplexField;
import io.permazen.core.CompositeIndex;
import io.permazen.core.CounterField;
import io.permazen.core.Field;
import io.permazen.core.FieldBuilder;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.ObjTypeStorageInfo;
import io.permazen.core.ReferenceField;
import io.permazen.core.Schema;
import io.permazen.core.SchemaItem;
import io.permazen.core.SimpleField;
import io.permazen.core.UnknownFieldException;
import io.permazen.core.UnknownIndexException;
import io.permazen.schema.SchemaCompositeIndex;
import io.permazen.schema.SchemaField;
import io.permazen.schema.SchemaObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ObjType
extends SchemaItem {
    final FieldTypeRegistry fieldTypeRegistry;
    final TreeMap<Integer, Field<?>> fields = new TreeMap();
    final TreeMap<String, Field<?>> fieldsByName = new TreeMap();
    final ArrayList<Field<?>> fieldsAndSubFields = new ArrayList();
    final TreeMap<Integer, CompositeIndex> compositeIndexes = new TreeMap();
    final TreeMap<String, CompositeIndex> compositeIndexesByName = new TreeMap();
    final TreeMap<Integer, SimpleField<?>> simpleFields = new TreeMap();
    final ArrayList<SimpleField<?>> indexedSimpleFields = new ArrayList();
    final TreeMap<Integer, ComplexField<?>> complexFields = new TreeMap();
    final TreeMap<Integer, CounterField> counterFields = new TreeMap();
    final TreeMap<Integer, ReferenceField> referenceFieldsAndSubFields = new TreeMap();

    ObjType(SchemaObjectType schemaObjectType, Schema schema, FieldTypeRegistry fieldTypeRegistry) {
        super(schemaObjectType.getName(), schemaObjectType.getStorageId(), schema);
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        this.fieldTypeRegistry = fieldTypeRegistry;
        FieldBuilder fieldBuilder = new FieldBuilder(this.schema, this.fieldTypeRegistry);
        for (SchemaField schemaField : schemaObjectType.getSchemaFields().values()) {
            this.addSchemaItem(this.fields, this.fieldsByName, (SchemaItem)schemaField.visit(fieldBuilder));
        }
        this.buildMap(this.simpleFields, SimpleField.class);
        this.buildMap(this.complexFields, ComplexField.class);
        this.buildMap(this.counterFields, CounterField.class);
        for (SimpleField simpleField : this.simpleFields.values()) {
            if (!simpleField.indexed) continue;
            this.indexedSimpleFields.add(simpleField);
        }
        this.indexedSimpleFields.trimToSize();
        this.fieldsAndSubFields.addAll(this.fields.values());
        for (ComplexField complexField : this.complexFields.values()) {
            this.fieldsAndSubFields.addAll(complexField.getSubFields());
        }
        this.fieldsAndSubFields.stream().filter(field -> field instanceof ReferenceField).forEach(field -> this.referenceFieldsAndSubFields.put(field.storageId, (ReferenceField)field));
        for (SchemaCompositeIndex schemaCompositeIndex : schemaObjectType.getSchemaCompositeIndexes().values()) {
            this.addCompositeIndex(this.schema, schemaCompositeIndex);
        }
        for (SimpleField simpleField : this.simpleFields.values()) {
            HashMap<CompositeIndex, Integer> indexMap = new HashMap<CompositeIndex, Integer>();
            for (CompositeIndex index : this.compositeIndexes.values()) {
                int i = index.fields.indexOf(simpleField);
                if (i == -1) continue;
                indexMap.put(index, i);
            }
            assert (simpleField.compositeIndexMap == null);
            if (indexMap.isEmpty()) continue;
            simpleField.compositeIndexMap = Collections.unmodifiableMap(indexMap);
        }
    }

    public SortedMap<Integer, Field<?>> getFields() {
        return Collections.unmodifiableSortedMap(this.fields);
    }

    public Field<?> getField(int storageId) {
        return this.getField(storageId, false);
    }

    public Field<?> getField(int storageId, boolean searchSubFields) {
        Field<?> field = this.fields.get(storageId);
        if (field != null) {
            return field;
        }
        if (searchSubFields) {
            for (Field<?> parent : this.fields.values()) {
                if (!(parent instanceof ComplexField)) continue;
                for (SimpleField<?> subField : ((ComplexField)parent).getSubFields()) {
                    if (subField.storageId != storageId) continue;
                    return subField;
                }
            }
        }
        throw new UnknownFieldException(this, storageId, "field");
    }

    public SortedMap<String, Field<?>> getFieldsByName() {
        return Collections.unmodifiableSortedMap(this.fieldsByName);
    }

    public SortedMap<Integer, CompositeIndex> getCompositeIndexes() {
        return Collections.unmodifiableSortedMap(this.compositeIndexes);
    }

    public CompositeIndex getCompositeIndex(int storageId) {
        CompositeIndex index = this.compositeIndexes.get(storageId);
        if (index == null) {
            throw new UnknownIndexException(storageId, "no composite index with storage ID " + storageId + " exists");
        }
        return index;
    }

    public SortedMap<String, CompositeIndex> getCompositeIndexesByName() {
        return Collections.unmodifiableSortedMap(this.compositeIndexesByName);
    }

    @Override
    ObjTypeStorageInfo toStorageInfo() {
        return new ObjTypeStorageInfo(this);
    }

    @Override
    public String toString() {
        return "object type `" + this.name + "' in " + this.schema;
    }

    private <T extends Field<?>> void buildMap(TreeMap<Integer, T> map, Class<? super T> type) {
        this.fields.values().stream().filter(field -> type.isInstance(field)).forEach(field -> map.put(field.storageId, (Field)type.cast(field)));
    }

    private <T extends SchemaItem> void addSchemaItem(Map<Integer, T> byStorageId, Map<String, T> byName, T item) {
        SchemaItem previous = (SchemaItem)byStorageId.put(item.storageId, item);
        if (previous != null) {
            throw new IllegalArgumentException("duplicate use of storage ID " + item.storageId + " by " + previous + " and " + item + " in " + this);
        }
        previous = (SchemaItem)byName.put(item.name, item);
        if (previous != null) {
            throw new IllegalArgumentException("duplicate use of name `" + item.name + "' by " + previous + " and " + item + " in " + this);
        }
    }

    private CompositeIndex addCompositeIndex(Schema schema, SchemaCompositeIndex schemaIndex) {
        int[] storageIds = Ints.toArray(schemaIndex.getIndexedFields());
        if (storageIds.length < 2 || storageIds.length > 4) {
            throw new IllegalArgumentException("invalid " + schemaIndex + ": can't index " + storageIds.length + " fields");
        }
        ArrayList<SimpleField> list = new ArrayList<SimpleField>(storageIds.length);
        boolean count = false;
        for (int storageId : storageIds) {
            Field<?> field = this.fields.get(storageId);
            if (!(field instanceof SimpleField)) {
                throw new IllegalArgumentException("invalid " + schemaIndex + ": no simple field with storage ID " + storageId + " found");
            }
            SimpleField simpleField = (SimpleField)field;
            if (simpleField.parent != null) {
                throw new IllegalArgumentException("invalid " + schemaIndex + ": simple field with storage ID " + storageId + " is a sub-field of a complex field");
            }
            list.add(simpleField);
        }
        CompositeIndex index = new CompositeIndex(schemaIndex.getName(), schemaIndex.getStorageId(), schema, this, list);
        this.addSchemaItem(this.compositeIndexes, this.compositeIndexesByName, index);
        return index;
    }
}

