/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.FieldTypeSet;
import io.permazen.core.ObjId;
import io.permazen.core.Transaction;
import io.permazen.kv.KVStore;
import io.permazen.kv.KeyFilter;
import io.permazen.kv.KeyRange;
import io.permazen.util.Bounds;
import io.permazen.util.ByteUtil;
import java.util.NavigableSet;

final class ObjTypeSet
extends FieldTypeSet<ObjId> {
    private final Transaction tx;

    ObjTypeSet(Transaction tx, int storageId) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, false, ByteUtil.EMPTY, ObjId.getKeyRange(storageId), null, new Bounds((Object)ObjId.getMin(storageId), (Object)ObjId.getMin(storageId + 1)));
        this.tx = tx;
    }

    ObjTypeSet(Transaction tx) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, false, ByteUtil.EMPTY, null, (KeyFilter)tx.schemas.objTypesKeyRanges, new Bounds());
        this.tx = tx;
    }

    private ObjTypeSet(Transaction tx, boolean reversed, byte[] prefix, KeyRange keyRange, KeyFilter keyFilter, Bounds<ObjId> bounds) {
        super((KVStore)tx.kvt, FieldTypeRegistry.OBJ_ID, true, reversed, prefix, keyRange, keyFilter, bounds);
        this.tx = tx;
    }

    public boolean remove(Object obj) {
        if (!(obj instanceof ObjId)) {
            return false;
        }
        ObjId id = (ObjId)obj;
        if (!this.isVisible(id.getBytes())) {
            return false;
        }
        return this.tx.delete(id);
    }

    protected NavigableSet<ObjId> createSubSet(boolean newReversed, KeyRange newKeyRange, KeyFilter newKeyFilter, Bounds<ObjId> newBounds) {
        return new ObjTypeSet(this.tx, newReversed, this.prefix, newKeyRange, newKeyFilter, newBounds);
    }
}

