/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.DatabaseException;
import io.permazen.core.ObjId;
import io.permazen.core.Transaction;

public class ReferencedObjectException
extends DatabaseException {
    private final ObjId id;
    private final ObjId referrer;
    private final int storageId;

    ReferencedObjectException(Transaction tx, ObjId id, ObjId referrer, int storageId) {
        super(tx.getObjDescription(id) + " cannot be deleted because it is still referenced by " + tx.getFieldDescription(referrer, storageId) + " in " + tx.getObjDescription(referrer) + ", which is configured for error on deletion");
        this.id = id;
        this.referrer = referrer;
        this.storageId = storageId;
    }

    public ObjId getId() {
        return this.id;
    }

    public ObjId getReferrer() {
        return this.referrer;
    }

    public int getStorageId() {
        return this.storageId;
    }
}

