/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import io.permazen.core.ObjId;
import io.permazen.core.SimpleField;
import io.permazen.core.SimpleFieldStorageInfo;
import io.permazen.core.Transaction;
import io.permazen.core.type.ReferenceFieldType;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Predicate;

class RegularSimpleFieldStorageInfo<T>
extends SimpleFieldStorageInfo<T> {
    RegularSimpleFieldStorageInfo(SimpleField<T> field) {
        super(field);
        assert (field.parent == null);
    }

    @Override
    void unreferenceAll(Transaction tx, ObjId target, NavigableSet<ObjId> referrers) {
        assert (this.fieldType instanceof ReferenceFieldType);
        for (ObjId referrer : referrers) {
            tx.writeSimpleField(referrer, this.storageId, null, false);
        }
    }

    @Override
    void readAllNonNull(Transaction tx, ObjId target, Set<T> values, Predicate<? super T> filter) {
        Object value = tx.readSimpleField(target, this.storageId, false);
        if (value != null && (filter == null || filter.test(value))) {
            values.add(value);
        }
    }

    @Override
    public String toString() {
        return "simple field with " + this.fieldType;
    }
}

