/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.permazen.core.CompositeIndexStorageInfo;
import io.permazen.core.IndexStorageInfo;
import io.permazen.core.InvalidSchemaException;
import io.permazen.core.ObjId;
import io.permazen.core.ObjTypeStorageInfo;
import io.permazen.core.Schema;
import io.permazen.core.SimpleFieldStorageInfo;
import io.permazen.core.StorageInfo;
import io.permazen.core.UnknownFieldException;
import io.permazen.core.UnknownIndexException;
import io.permazen.core.UnknownTypeException;
import io.permazen.core.type.ReferenceFieldType;
import io.permazen.kv.KeyRanges;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class Schemas {
    final TreeMap<Integer, Schema> versions = new TreeMap();
    final TreeMap<Integer, StorageInfo> storageInfos = new TreeMap();
    final ArrayList<SimpleFieldStorageInfo<?>> referenceFieldIndexStorageInfos = new ArrayList();
    final TreeSet<Integer> objTypeStorageIds = new TreeSet();
    KeyRanges objTypesKeyRanges;

    Schemas(SortedMap<Integer, Schema> versions) {
        this.initialize(versions);
    }

    private void initialize(SortedMap<Integer, Schema> versions) {
        Preconditions.checkArgument((versions != null ? 1 : 0) != 0, (Object)"null versions");
        for (Map.Entry<Integer, Schema> entry : versions.entrySet()) {
            int versionNumber = entry.getKey();
            Schema schema = entry.getValue();
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"null schema");
            if (schema.versionNumber == versionNumber) continue;
            throw new InvalidSchemaException("schema version at index " + versionNumber + " has version " + schema.versionNumber);
        }
        this.versions.clear();
        this.storageInfos.clear();
        this.objTypeStorageIds.clear();
        this.versions.putAll(versions);
        HashMap<StorageInfo, Integer> versionMap = new HashMap<StorageInfo, Integer>();
        for (Schema version : this.versions.values()) {
            for (Map.Entry entry : version.storageInfoMap.entrySet()) {
                int storageId = (Integer)entry.getKey();
                StorageInfo current = (StorageInfo)entry.getValue();
                StorageInfo previous = this.storageInfos.put(storageId, current);
                if (previous != null && !previous.equals(current)) {
                    throw new InvalidSchemaException("incompatible use of storage ID " + storageId + " by both " + previous + " in schema version " + versionMap.get(previous) + " and " + current + " in schema version " + version.versionNumber);
                }
                versionMap.put(current, version.versionNumber);
            }
        }
        for (Schema version : this.versions.values()) {
            version.objTypeMap.values().stream().map(objType -> objType.storageId).forEach(this.objTypeStorageIds::add);
        }
        for (StorageInfo info : this.storageInfos.values()) {
            if (!(info instanceof SimpleFieldStorageInfo)) continue;
            SimpleFieldStorageInfo simpleInfo = (SimpleFieldStorageInfo)info;
            if (!(simpleInfo.fieldType instanceof ReferenceFieldType)) continue;
            this.referenceFieldIndexStorageInfos.add(simpleInfo);
        }
        this.objTypesKeyRanges = new KeyRanges(Iterables.transform(this.objTypeStorageIds, ObjId::getKeyRange));
    }

    <T extends StorageInfo> T verifyStorageInfo(int storageId, Class<T> expectedType) {
        StorageInfo storageInfo = this.storageInfos.get(storageId);
        if (storageInfo != null && expectedType.isInstance(storageInfo)) {
            return (T)((StorageInfo)expectedType.cast(storageInfo));
        }
        String message = "no " + this.getDescription(expectedType) + " with storage ID " + storageId + " exists";
        if (storageInfo != null) {
            message = message + " (found " + storageInfo + " instead)";
        }
        if (SimpleFieldStorageInfo.class.isAssignableFrom(expectedType)) {
            throw new UnknownFieldException(storageId, message);
        }
        if (ObjTypeStorageInfo.class.isAssignableFrom(expectedType)) {
            throw new UnknownTypeException(storageId, 0, message);
        }
        if (IndexStorageInfo.class.isAssignableFrom(expectedType)) {
            throw new UnknownIndexException(storageId, message);
        }
        throw new IllegalArgumentException(message);
    }

    boolean deleteVersion(int version) {
        TreeMap<Integer, Schema> newVersions = new TreeMap<Integer, Schema>((SortedMap<Integer, Schema>)this.versions);
        if (newVersions.remove(version) == null) {
            return false;
        }
        this.initialize(newVersions);
        return true;
    }

    private String getDescription(Class<? extends StorageInfo> type) {
        if (SimpleFieldStorageInfo.class.isAssignableFrom(type)) {
            return type.getSimpleName().replaceAll("^(.*)StorageInfo$", "$1").replaceAll("([a-z])([A-Z])", "$1 $2").toLowerCase() + " index";
        }
        if (ObjTypeStorageInfo.class.isAssignableFrom(type)) {
            return "object type";
        }
        if (CompositeIndexStorageInfo.class.isAssignableFrom(type)) {
            return "composite index";
        }
        return type.getSimpleName();
    }

    public SortedMap<Integer, Schema> getVersions() {
        return Collections.unmodifiableSortedMap(this.versions);
    }

    public Schema getVersion(int versionNumber) {
        Schema schema = this.versions.get(versionNumber);
        if (schema == null) {
            throw new IllegalArgumentException("unknown version " + versionNumber);
        }
        return schema;
    }

    boolean isSameVersions(SortedMap<Integer, byte[]> bytesList) {
        if (bytesList.size() != this.versions.size()) {
            return false;
        }
        Iterator<Map.Entry<Integer, byte[]>> i1 = bytesList.entrySet().iterator();
        Iterator<Map.Entry<Integer, Schema>> i2 = this.versions.entrySet().iterator();
        while (i1.hasNext() || i2.hasNext()) {
            if (!i1.hasNext() || !i2.hasNext()) {
                return false;
            }
            Map.Entry<Integer, byte[]> entry1 = i1.next();
            Map.Entry<Integer, Schema> entry2 = i2.next();
            if (entry1.getKey().intValue() == entry2.getKey().intValue() && Arrays.equals(entry1.getValue(), entry2.getValue().encodedXML)) continue;
            return false;
        }
        return true;
    }
}

