/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core;

import com.google.common.base.Preconditions;
import io.permazen.core.ComplexField;
import io.permazen.core.CompositeIndex;
import io.permazen.core.Field;
import io.permazen.core.FieldSwitch;
import io.permazen.core.FieldType;
import io.permazen.core.ObjId;
import io.permazen.core.RegularSimpleFieldStorageInfo;
import io.permazen.core.Schema;
import io.permazen.core.SimpleFieldStorageInfo;
import io.permazen.core.Transaction;
import io.permazen.core.util.ObjIdMap;
import io.permazen.util.ByteWriter;
import java.util.Arrays;
import java.util.Map;

public class SimpleField<T>
extends Field<T> {
    final FieldType<T> fieldType;
    final boolean indexed;
    ComplexField<?> parent;
    Map<CompositeIndex, Integer> compositeIndexMap;

    SimpleField(String name, int storageId, Schema schema, FieldType<T> fieldType, boolean indexed) {
        super(name, storageId, schema, fieldType.getTypeToken());
        this.fieldType = fieldType;
        this.indexed = indexed;
    }

    public FieldType<T> getFieldType() {
        return this.fieldType;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setValue(Transaction tx, ObjId id, T value) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((this.parent == null ? 1 : 0) != 0, (Object)("field is a sub-field of " + this.parent));
        tx.writeSimpleField(id, this.storageId, value, false);
    }

    @Override
    public T getValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((this.parent == null ? 1 : 0) != 0, (Object)("field is a sub-field of " + this.parent));
        return (T)tx.readSimpleField(id, this.storageId, false);
    }

    @Override
    public boolean hasDefaultValue(Transaction tx, ObjId id) {
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0, (Object)"null tx");
        Preconditions.checkArgument((this.parent == null ? 1 : 0) != 0, (Object)("field is a sub-field of " + this.parent));
        return tx.hasDefaultValue(id, this);
    }

    @Override
    public <R> R visit(FieldSwitch<R> target) {
        return target.caseSimpleField(this);
    }

    @Override
    public String toString() {
        return (this.indexed ? "indexed " : "") + "field `" + this.name + "' of type " + this.fieldType.typeToken;
    }

    @Override
    SimpleFieldStorageInfo<?> toStorageInfo() {
        if (!this.indexed) {
            return null;
        }
        return this.parent != null ? this.parent.toStorageInfo(this) : new RegularSimpleFieldStorageInfo(this);
    }

    @Override
    void copy(ObjId srcId, ObjId dstId, Transaction srcTx, Transaction dstTx, ObjIdMap<ObjId> objectIdMap) {
        Object value = srcTx.readSimpleField(srcId, this.storageId, false);
        if (objectIdMap != null) {
            value = this.remapObjectId(objectIdMap, value);
        }
        dstTx.writeSimpleField(dstId, this.storageId, value, false);
    }

    protected boolean remapsObjectId() {
        return false;
    }

    protected T remapObjectId(ObjIdMap<ObjId> objectIdMap, T value) {
        return value;
    }

    byte[] encode(Object obj) {
        T value;
        try {
            value = this.fieldType.validate(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("can't set " + this + " to value " + obj + ": " + e.getMessage(), e);
        }
        ByteWriter writer = new ByteWriter();
        this.fieldType.write(writer, value);
        byte[] result = writer.getBytes();
        return Arrays.equals(result, this.fieldType.getDefaultValue()) ? null : result;
    }

    @Override
    boolean isUpgradeCompatible(Field<?> field) {
        if (field.getClass() != this.getClass()) {
            return false;
        }
        SimpleField that = (SimpleField)field;
        return this.fieldType.equals(that.fieldType);
    }
}

