/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteUtil;
import io.permazen.util.ByteWriter;
import io.permazen.util.ParseContext;
import java.net.InetAddress;
import java.net.UnknownHostException;

abstract class AbstractInetAddressType<T extends InetAddress>
extends NonNullFieldType<T> {
    private static final long serialVersionUID = -3778250973615531382L;
    private final Class<T> addrType;
    private final String pattern;

    protected AbstractInetAddressType(Class<T> type, String pattern) {
        super(type, 0L);
        this.addrType = type;
        this.pattern = pattern;
    }

    @Override
    public T read(ByteReader reader) {
        InetAddress addr;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        try {
            addr = InetAddress.getByAddress(reader.readBytes(this.getLength(reader)));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return (T)((InetAddress)this.addrType.cast(addr));
    }

    protected abstract int getLength(ByteReader var1);

    @Override
    public void write(ByteWriter writer, T addr) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((addr != null ? 1 : 0) != 0);
        byte[] bytes = ((InetAddress)addr).getAddress();
        assert (bytes.length == this.getLength(new ByteReader(bytes)));
        writer.write(((InetAddress)addr).getAddress());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(this.getLength(reader));
    }

    @Override
    public String toString(T addr) {
        Preconditions.checkArgument((addr != null ? 1 : 0) != 0);
        return InetAddresses.toAddrString(addr);
    }

    @Override
    public T fromString(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"null string");
        try {
            return (T)((InetAddress)this.addrType.cast(InetAddresses.forString((String)string)));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("invalid " + this.addrType.getSimpleName() + " `" + string + "'");
        }
    }

    @Override
    public String toParseableString(T addr) {
        return this.toString(addr);
    }

    @Override
    public T fromParseableString(ParseContext ctx) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        return (T)this.fromString(ctx.matchPrefix(this.pattern).group());
    }

    @Override
    public int compare(T addr1, T addr2) {
        byte[] bytes2;
        byte[] bytes1 = ((InetAddress)addr1).getAddress();
        int diff = Integer.compare(bytes1.length, (bytes2 = ((InetAddress)addr2).getAddress()).length);
        if (diff != 0) {
            return diff;
        }
        return ByteUtil.compare((byte[])bytes1, (byte[])bytes2);
    }
}

