/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.permazen.core.FieldType;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.core.type.NullSafeType;
import io.permazen.util.ParseContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public abstract class ArrayType<T, E>
extends NonNullFieldType<T> {
    public static final String ARRAY_SUFFIX = "[]";
    public static final int MAX_DIMENSIONS = 255;
    private static final long serialVersionUID = 3776218636387986632L;
    final FieldType<E> elementType;
    final int dimensions;

    protected ArrayType(FieldType<E> elementType, TypeToken<T> typeToken) {
        super(elementType.getName() + ARRAY_SUFFIX, typeToken, elementType.getEncodingSignature(), Array.newInstance(elementType.getTypeToken().getRawType(), 0));
        this.elementType = elementType;
        this.dimensions = elementType instanceof ArrayType ? ((ArrayType)elementType).dimensions + 1 : 1;
        Preconditions.checkArgument((this.dimensions <= 255 ? 1 : 0) != 0, (Object)"too many array dimensions");
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public String toParseableString(T array) {
        assert (array != null);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int length = this.getArrayLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(',').append(' ');
            }
            buf.append(this.elementType.toParseableString(this.getArrayElement(array, i)));
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public T fromParseableString(ParseContext context) {
        ArrayList<E> list = new ArrayList<E>();
        context.expect('[');
        while (true) {
            context.skipWhitespace();
            if (context.tryLiteral("]")) break;
            if (!list.isEmpty()) {
                context.expect(',');
                context.skipWhitespace();
            }
            list.add(this.elementType.fromParseableString(context));
        }
        return this.createArray(list);
    }

    @Override
    public int compare(T array1, T array2) {
        int i;
        int length1 = this.getArrayLength(array1);
        int length2 = this.getArrayLength(array2);
        for (i = 0; i < length1 && i < length2; ++i) {
            int diff = this.elementType.compare(this.getArrayElement(array1, i), this.getArrayElement(array2, i));
            if (diff == 0) continue;
            return diff;
        }
        if (i < length2) {
            return -1;
        }
        if (i < length1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.elementType.hashCode() ^ this.dimensions;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArrayType that = (ArrayType)obj;
        return this.dimensions == that.dimensions && this.elementType.equals(that.elementType);
    }

    @Override
    public <S> T convert(FieldType<S> type, S value) {
        if (value == null) {
            throw new IllegalArgumentException("invalid null value");
        }
        if (type instanceof NullSafeType) {
            type = ((NullSafeType)type).inner;
        }
        if (type instanceof ArrayType) {
            return this.convertArray((ArrayType)type, value);
        }
        return super.convert(type, value);
    }

    private <S, F> T convertArray(ArrayType<S, F> that, S value) {
        int length = that.getArrayLength(value);
        ArrayList<E> list = new ArrayList<E>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.elementType.convert(that.elementType, that.getArrayElement(value, i)));
        }
        return this.createArray(list);
    }

    protected abstract int getArrayLength(T var1);

    protected abstract E getArrayElement(T var1, int var2);

    protected abstract T createArray(List<E> var1);
}

