/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import io.permazen.util.UnsignedIntEncoder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class BigDecimalType
extends NonNullFieldType<BigDecimal> {
    private static final long serialVersionUID = -6401896548616656153L;
    private static final int FLAG_NEGATIVE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_POSITIVE = 3;

    public BigDecimalType() {
        super(BigDecimal.class, 0L);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    public BigDecimal read(ByteReader reader) {
        boolean negative;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        switch (reader.readByte()) {
            case 2: {
                return new BigDecimal(BigInteger.ZERO, UnsignedIntEncoder.read((ByteReader)reader));
            }
            case 1: {
                negative = true;
                break;
            }
            case 3: {
                negative = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid encoded BigDecimal");
            }
        }
        long exponent = LongEncoder.read((ByteReader)reader);
        if (negative) {
            exponent = -exponent;
        }
        Preconditions.checkArgument((exponent >= -2147483647L && exponent <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"invalid encoded BigDecimal");
        StringBuilder digits = new StringBuilder();
        block5: while (true) {
            int value = reader.readByte();
            assert ((value & 0xFFFFFF00) == 0);
            if (negative) {
                value ^= 0xFF;
            }
            int[] nArray = new int[]{value >> 4, value & 0xF};
            int n = nArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block5;
                int nibble = nArray[n2];
                if (nibble-- == 0) break block5;
                if (nibble > 9) {
                    throw new IllegalArgumentException("invalid encoded BigDecimal");
                }
                digits.append(Character.forDigit(nibble, 10));
                ++n2;
            }
            break;
        }
        BigInteger unscaledValue = new BigInteger(digits.toString());
        long scale = (long)(digits.length() - 1) - exponent;
        Preconditions.checkArgument((scale >= -2147483647L && scale <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"invalid encoded BigDecimal");
        BigDecimal value = new BigDecimal(unscaledValue, (int)scale);
        return negative ? value.negate() : value;
    }

    @Override
    public void write(ByteWriter writer, BigDecimal value) {
        String digits;
        boolean negative;
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        if (value.signum() == 0) {
            writer.writeByte(2);
            UnsignedIntEncoder.write((ByteWriter)writer, (int)value.scale());
            return;
        }
        boolean bl = negative = value.signum() < 0;
        if (negative) {
            value = value.abs();
        }
        if (value.unscaledValue().equals(BigInteger.ZERO)) {
            char[] array = new char[value.scale() + 1];
            Arrays.fill(array, '0');
            digits = new String(array);
        } else {
            digits = value.unscaledValue().toString();
        }
        long exponent = digits.length() - 1 - value.scale();
        writer.writeByte(negative ? 1 : 3);
        LongEncoder.write((ByteWriter)writer, (long)(negative ? -exponent : exponent));
        int nextByte = 0;
        for (int i = 0; i < digits.length(); ++i) {
            int digit = Character.digit(digits.charAt(i), 10);
            assert (digit >= 0 && digit < 10);
            nextByte = nextByte << 4 | digit + 1;
            if ((i & 1) != 1) continue;
            writer.writeByte(negative ? ~nextByte : nextByte);
        }
        nextByte = (digits.length() & 1) == 1 ? (nextByte <<= 4) : 0;
        writer.writeByte(negative ? ~nextByte : nextByte);
    }

    @Override
    public void skip(ByteReader reader) {
        int value;
        int flag = reader.readByte();
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        if (flag == 2) {
            return;
        }
        while (((value = reader.readByte()) & 0xF) != 0) {
        }
    }

    @Override
    public String toString(BigDecimal value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        return value.toString();
    }

    @Override
    public BigDecimal fromString(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return new BigDecimal(string);
    }

    @Override
    public String toParseableString(BigDecimal value) {
        return this.toString(value);
    }

    @Override
    public BigDecimal fromParseableString(ParseContext ctx) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        return this.fromString(ctx.matchPrefix("[-+]?(\\p{Digit}+(\\.\\p{Digit}+)?|\\.\\p{Digit}+)([Ee][-+]?\\p{Digit}+)?").group());
    }

    @Override
    public int compare(BigDecimal value1, BigDecimal value2) {
        int diff = value1.compareTo(value2);
        if (diff != 0) {
            return diff;
        }
        return value1.signum() < 0 ? Integer.compare(value2.scale(), value1.scale()) : Integer.compare(value1.scale(), value2.scale());
    }
}

