/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.math.BigInteger;

public class BigIntegerType
extends NonNullFieldType<BigInteger> {
    private static final long serialVersionUID = -2984648309356838144L;
    private static final int MAX_NUM_BYTES = 0x10000000;

    public BigIntegerType() {
        super(BigInteger.class, 0L);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    public BigInteger read(ByteReader reader) {
        int numBytes = this.readSignedNumBytes(reader);
        return numBytes == 0 ? BigInteger.ZERO : new BigInteger(reader.readBytes(numBytes < 0 ? -numBytes : numBytes));
    }

    @Override
    public void write(ByteWriter writer, BigInteger value) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        if (value.signum() == 0) {
            LongEncoder.write((ByteWriter)writer, (long)0L);
            return;
        }
        byte[] bytes = value.toByteArray();
        assert (bytes.length <= 0x10000000);
        assert ((bytes[0] & 0x80) != 0 == value.signum() < 0);
        LongEncoder.write((ByteWriter)writer, (long)(value.signum() < 0 ? (long)(-bytes.length) : (long)bytes.length));
        writer.write(bytes);
    }

    @Override
    public void skip(ByteReader reader) {
        int numBytes = this.readSignedNumBytes(reader);
        if (numBytes > 0) {
            reader.skip(numBytes);
        } else if (numBytes < 0) {
            reader.skip(-numBytes);
        }
    }

    private int readSignedNumBytes(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        long flag = LongEncoder.read((ByteReader)reader);
        Preconditions.checkArgument((flag >= -268435456L && flag <= 0x10000000L ? 1 : 0) != 0, (Object)"invalid BigInteger flag byte");
        if (flag != 0L) {
            int firstByte = reader.peek();
            Preconditions.checkArgument(((firstByte & 0x80) != 0 == flag < 0L ? 1 : 0) != 0, (Object)"invalid encoded BigInteger");
        }
        return (int)flag;
    }

    @Override
    public String toString(BigInteger value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        return value.toString();
    }

    @Override
    public BigInteger fromString(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return new BigInteger(string);
    }

    @Override
    public String toParseableString(BigInteger value) {
        return this.toString(value);
    }

    @Override
    public BigInteger fromParseableString(ParseContext ctx) {
        Preconditions.checkArgument((ctx != null ? 1 : 0) != 0);
        return this.fromString(ctx.matchPrefix("-?\\p{Digit}+").group());
    }

    @Override
    public int compare(BigInteger value1, BigInteger value2) {
        return value1.compareTo(value2);
    }
}

