/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import com.google.common.reflect.TypeToken;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.type.ArrayType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.util.BitSet;
import java.util.List;

public class BooleanArrayType
extends ArrayType<boolean[], Boolean> {
    private static final long serialVersionUID = -7254445869697946454L;
    private static final int END = 0;
    private static final int FALSE = 1;
    private static final int TRUE = 2;

    public BooleanArrayType() {
        super(FieldTypeRegistry.BOOLEAN, new TypeToken<boolean[]>(){});
    }

    @Override
    public boolean[] read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        BitSet bits = new BitSet();
        int count = 0;
        block5: while (true) {
            int value = reader.readByte();
            int shift = 6;
            while (true) {
                if (shift < 0) continue block5;
                switch (value >> shift & 3) {
                    case 0: {
                        break block5;
                    }
                    case 1: {
                        bits.clear(count++);
                        break;
                    }
                    case 2: {
                        bits.set(count++);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid encoding of " + this);
                    }
                }
                shift -= 2;
            }
            break;
        }
        boolean[] result = new boolean[count];
        for (int i = 0; i < count; ++i) {
            result[i] = bits.get(i);
        }
        return result;
    }

    @Override
    public void write(ByteWriter writer, boolean[] array) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int value = 0;
        for (int i = 0; i < array.length; ++i) {
            int phase = i % 4;
            int shift = 2 * (3 - phase);
            value |= (array[i] ? 2 : 1) << shift;
            if (phase != 3) continue;
            writer.writeByte(value);
            value = 0;
        }
        writer.writeByte(value);
    }

    @Override
    public void skip(ByteReader reader) {
        int value;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        while (((value = reader.readByte()) & 0xC0) != 0 && (value & 0x30) != 0 && (value & 0xC) != 0 && (value & 3) != 0) {
        }
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    protected int getArrayLength(boolean[] array) {
        return array.length;
    }

    @Override
    protected Boolean getArrayElement(boolean[] array, int index) {
        return array[index];
    }

    @Override
    protected boolean[] createArray(List<Boolean> elements) {
        return Booleans.toArray(elements);
    }
}

