/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.util.Date;
import org.dellroad.stuff.string.DateEncoder;

public class DateType
extends NonNullFieldType<Date> {
    private static final long serialVersionUID = 825120832596893074L;

    public DateType() {
        super(Date.class, 0L);
    }

    @Override
    public Date read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return new Date(LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, Date date) {
        Preconditions.checkArgument((date != null ? 1 : 0) != 0, (Object)"null date");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)date.getTime());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public Date fromParseableString(ParseContext ctx) {
        return DateEncoder.decode((String)ctx.matchPrefix("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]{3})?(Z)?").group());
    }

    @Override
    public String toParseableString(Date date) {
        return DateEncoder.encode((Date)date);
    }

    @Override
    public int compare(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

