/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.reflect.TypeToken;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.type.Base64ArrayType;
import io.permazen.core.type.DoubleType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DoubleArrayType
extends Base64ArrayType<double[], Double> {
    private static final long serialVersionUID = 7502947488125172882L;
    private static final int NUM_BYTES = 8;
    private static final byte[] END = new byte[8];
    private final DoubleType doubleType = new DoubleType();

    public DoubleArrayType() {
        super(FieldTypeRegistry.DOUBLE, new TypeToken<double[]>(){});
    }

    @Override
    public double[] read(ByteReader reader) {
        byte[] next;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        ArrayList<Double> list = new ArrayList<Double>();
        while (!Arrays.equals(next = reader.readBytes(8), END)) {
            list.add(this.doubleType.read(new ByteReader(next)));
        }
        return this.createArray((List<Double>)list);
    }

    @Override
    public void write(ByteWriter writer, double[] array) {
        Preconditions.checkArgument((array != null ? 1 : 0) != 0, (Object)"null array");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int length = this.getArrayLength(array);
        for (int i = 0; i < length; ++i) {
            this.doubleType.write(writer, array[i]);
        }
        writer.write(END);
    }

    @Override
    public void skip(ByteReader reader) {
        byte[] next;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        while (!Arrays.equals(next = reader.readBytes(8), END)) {
        }
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.doubleType.hasPrefix0xff();
    }

    @Override
    protected int getArrayLength(double[] array) {
        return array.length;
    }

    @Override
    protected Double getArrayElement(double[] array, int index) {
        return array[index];
    }

    @Override
    protected double[] createArray(List<Double> elements) {
        return Doubles.toArray(elements);
    }

    @Override
    protected void encode(double[] array, DataOutputStream output) throws IOException {
        for (double value : array) {
            output.writeDouble(value);
        }
    }

    @Override
    protected double[] decode(DataInputStream input, int numBytes) throws IOException {
        double[] array = (double[])this.checkDecodeLength(numBytes);
        for (int i = 0; i < array.length; ++i) {
            array[i] = input.readDouble();
        }
        return array;
    }
}

