/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.time.Duration;
import java.util.regex.Pattern;

public class DurationType
extends NonNullFieldType<Duration> {
    private static final Pattern PATTERN = Pattern.compile("PT(-?[0-9]+H)?(-?[0-9]+M)?(-?[0-9]+(\\.[0-9]+)?S)?");
    private static final long serialVersionUID = 969067179729229705L;

    public DurationType() {
        super(Duration.class, 0L, Duration.ZERO);
    }

    @Override
    public Duration read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return Duration.ofSeconds(LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, Duration duration) {
        Preconditions.checkArgument((duration != null ? 1 : 0) != 0, (Object)"null duration");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)duration.getSeconds());
        LongEncoder.write((ByteWriter)writer, (long)duration.getNano());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public Duration fromParseableString(ParseContext ctx) {
        return Duration.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(Duration duration) {
        return duration.toString();
    }

    @Override
    public int compare(Duration duration1, Duration duration2) {
        return duration1.compareTo(duration2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

