/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.AbstractInetAddressType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.net.InetAddress;

public class InetAddressType
extends AbstractInetAddressType<InetAddress> {
    private static final long serialVersionUID = 3568938922398348273L;
    private static final byte PREFIX_IPV4 = 4;
    private static final byte PREFIX_IPV6 = 6;

    public InetAddressType() {
        super(InetAddress.class, "([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+|[:\\p{XDigit}]+)");
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    @Override
    protected int getLength(ByteReader reader) {
        switch (reader.readByte()) {
            case 4: {
                return 4;
            }
            case 6: {
                return 16;
            }
        }
        throw new IllegalArgumentException("invalid encoded InetAddress");
    }

    @Override
    public void write(ByteWriter writer, InetAddress addr) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Preconditions.checkArgument((addr != null ? 1 : 0) != 0);
        byte[] bytes = addr.getAddress();
        switch (bytes.length) {
            case 4: {
                writer.writeByte(4);
                break;
            }
            case 16: {
                writer.writeByte(6);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        writer.write(bytes);
    }
}

