/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.time.Instant;
import java.util.regex.Pattern;

public class InstantType
extends NonNullFieldType<Instant> {
    private static final Pattern PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?Z");
    private static final long serialVersionUID = -3907615112193058091L;

    public InstantType() {
        super(Instant.class, 0L);
    }

    @Override
    public Instant read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return Instant.ofEpochSecond(LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, Instant instant) {
        Preconditions.checkArgument((instant != null ? 1 : 0) != 0, (Object)"null instant");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)instant.getEpochSecond());
        LongEncoder.write((ByteWriter)writer, (long)instant.getNano());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public Instant fromParseableString(ParseContext ctx) {
        return Instant.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(Instant instant) {
        return instant.toString();
    }

    @Override
    public int compare(Instant instant1, Instant instant2) {
        return instant1.compareTo(instant2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

