/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.permazen.core.type.Base64ArrayType;
import io.permazen.core.type.IntegralType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import java.util.ArrayList;

public abstract class IntegralArrayType<T, E extends Number>
extends Base64ArrayType<T, E> {
    private static final long serialVersionUID = -5185297639150351646L;
    private static final int END = 0;
    private final IntegralType<E> integralType;

    protected IntegralArrayType(IntegralType<E> elementType, Class<T> arrayClass) {
        super(elementType, TypeToken.of(arrayClass));
        if (this.elementType.hasPrefix0x00()) {
            throw new RuntimeException("internal error");
        }
        this.integralType = elementType;
    }

    @Override
    public T read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        ArrayList<E> list = new ArrayList<E>();
        while (true) {
            int first;
            if ((first = reader.peek()) == 0) break;
            list.add(this.integralType.downCast(LongEncoder.read((ByteReader)reader)));
        }
        reader.skip(1);
        return this.createArray(list);
    }

    @Override
    public void write(ByteWriter writer, T array) {
        Preconditions.checkArgument((array != null ? 1 : 0) != 0, (Object)"null array");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int length = this.getArrayLength(array);
        for (int i = 0; i < length; ++i) {
            LongEncoder.write((ByteWriter)writer, (long)this.integralType.upCast((Number)this.getArrayElement(array, i)));
        }
        writer.writeByte(0);
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        while (true) {
            int first;
            if ((first = reader.peek()) == 0) break;
            reader.skip(LongEncoder.decodeLength((int)first));
        }
        reader.skip(1);
    }

    @Override
    public boolean hasPrefix0xff() {
        return this.integralType.hasPrefix0xff();
    }
}

