/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NumberType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import org.dellroad.stuff.java.Primitive;

public abstract class IntegralType<T extends Number>
extends NumberType<T> {
    private static final long serialVersionUID = -4654999812179346709L;

    protected IntegralType(Primitive<T> primitive) {
        super(primitive);
    }

    @Override
    public T read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return this.downCast(LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"null value");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)this.upCast(value));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }

    protected abstract T downCast(long var1);

    protected long upCast(T value) {
        return ((Number)value).longValue();
    }
}

