/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Converter;
import io.permazen.core.type.StringEncodedType;
import java.io.Serializable;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class InternetAddressType
extends StringEncodedType<InternetAddress> {
    private static final long serialVersionUID = 289940859247032224L;

    public InternetAddressType() {
        super(InternetAddress.class, 0L, new InternetAddressConverter());
    }

    private static class InternetAddressConverter
    extends Converter<InternetAddress, String>
    implements Serializable {
        private static final long serialVersionUID = 3837763387234872160L;

        private InternetAddressConverter() {
        }

        protected String doForward(InternetAddress address) {
            if (address == null) {
                return null;
            }
            return address.toString();
        }

        protected InternetAddress doBackward(String string) {
            if (string == null) {
                return null;
            }
            try {
                return new InternetAddress(string);
            }
            catch (AddressException e) {
                throw new IllegalArgumentException("invalid email address `" + string + "'", e);
            }
        }
    }
}

