/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.regex.Pattern;

public class LocalDateTimeType
extends NonNullFieldType<LocalDateTime> {
    static final Pattern PATTERN = Pattern.compile("-?[0-9]+-[0-9]+-[0-9]+T[0-9]+:[0-9]+(:[0-9]+(\\.[0-9]+)?)?");
    private static final long serialVersionUID = -3302238853808401737L;

    public LocalDateTimeType() {
        super(LocalDateTime.class, 0L);
    }

    @Override
    public LocalDateTime read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return LocalDateTime.ofEpochSecond(LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader), ZoneOffset.UTC);
    }

    @Override
    public void write(ByteWriter writer, LocalDateTime localDateTime) {
        Preconditions.checkArgument((localDateTime != null ? 1 : 0) != 0, (Object)"null localDateTime");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        Instant instant = localDateTime.toInstant(ZoneOffset.UTC);
        LongEncoder.write((ByteWriter)writer, (long)instant.getEpochSecond());
        LongEncoder.write((ByteWriter)writer, (long)instant.getNano());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public LocalDateTime fromParseableString(ParseContext ctx) {
        return LocalDateTime.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(LocalDateTime localDateTime) {
        return localDateTime.toString();
    }

    @Override
    public int compare(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        return localDateTime1.compareTo(localDateTime2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

