/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.ParseContext;
import io.permazen.util.UnsignedIntEncoder;
import java.time.MonthDay;
import java.util.regex.Pattern;

public class MonthDayType
extends NonNullFieldType<MonthDay> {
    private static final Pattern PATTERN = Pattern.compile("--[0-9]{2}-[0-9]{2}");
    private static final long serialVersionUID = -8813919603844250786L;

    public MonthDayType() {
        super(MonthDay.class, 0L);
    }

    @Override
    public MonthDay read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        int value = UnsignedIntEncoder.read((ByteReader)reader);
        return MonthDay.of((value >> 5) + 1, (value & 0x1F) + 1);
    }

    @Override
    public void write(ByteWriter writer, MonthDay monthDay) {
        Preconditions.checkArgument((monthDay != null ? 1 : 0) != 0, (Object)"null monthDay");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        int month = monthDay.getMonthValue();
        int day = monthDay.getDayOfMonth();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)(month - 1 << 5 | day - 1));
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(UnsignedIntEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public MonthDay fromParseableString(ParseContext ctx) {
        return MonthDay.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(MonthDay monthDay) {
        return monthDay.toString();
    }

    @Override
    public int compare(MonthDay monthDay1, MonthDay monthDay2) {
        return monthDay1.compareTo(monthDay2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return true;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

