/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.permazen.core.FieldType;
import io.permazen.core.type.ArrayType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ObjectArrayType<E>
extends ArrayType<E[], E> {
    private static final long serialVersionUID = -2337331922923184256L;
    private static final int END = 0;
    private static final int VALUE = 1;
    private final boolean inline;

    public ObjectArrayType(FieldType<E> elementType) {
        super(elementType, new TypeToken<E[]>(){}.where(new TypeParameter<E>(){}, elementType.getTypeToken()));
        Preconditions.checkArgument((!elementType.getTypeToken().isPrimitive() ? 1 : 0) != 0, (Object)"illegal primitive element type");
        this.inline = !elementType.hasPrefix0x00();
    }

    @Override
    public E[] read(ByteReader reader) {
        int first;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        ArrayList list = new ArrayList();
        while ((first = reader.readByte()) != 0) {
            if (this.inline) {
                reader.unread();
            } else if (first != 1) {
                throw new IllegalArgumentException("invalid encoding of " + this);
            }
            list.add(this.elementType.read(reader));
        }
        return this.createArray(list);
    }

    @Override
    public void write(ByteWriter writer, E[] array) {
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        for (E obj : array) {
            if (!this.inline) {
                writer.writeByte(1);
            }
            this.elementType.write(writer, obj);
        }
        writer.writeByte(0);
    }

    @Override
    public void skip(ByteReader reader) {
        int first;
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        while ((first = reader.readByte()) != 0) {
            if (this.inline) {
                reader.unread();
            } else if (first != 1) {
                throw new IllegalArgumentException("invalid encoding of " + this);
            }
            this.elementType.skip(reader);
        }
    }

    @Override
    protected int getArrayLength(E[] array) {
        return array.length;
    }

    @Override
    protected E getArrayElement(E[] array, int index) {
        return array[index];
    }

    @Override
    protected E[] createArray(List<E> elements) {
        return elements.toArray((Object[])Array.newInstance(this.elementType.getTypeToken().getRawType(), elements.size()));
    }
}

