/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import io.permazen.core.type.Concat2Type;
import io.permazen.core.type.InstantType;
import io.permazen.core.type.LocalDateTimeType;
import io.permazen.core.type.ZoneOffsetType;
import io.permazen.util.ParseContext;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeType
extends Concat2Type<OffsetDateTime, Instant, ZoneOffset> {
    private static final long serialVersionUID = -1216769026293613698L;

    public OffsetDateTimeType() {
        super(OffsetDateTime.class, 0L, new InstantType(), new ZoneOffsetType());
    }

    @Override
    protected OffsetDateTime join(Instant value1, ZoneOffset value2) {
        return OffsetDateTime.ofInstant(value1, value2);
    }

    @Override
    protected Instant split1(OffsetDateTime value) {
        return value.toInstant();
    }

    @Override
    protected ZoneOffset split2(OffsetDateTime value) {
        return value.getOffset();
    }

    @Override
    public OffsetDateTime fromParseableString(ParseContext ctx) {
        return OffsetDateTime.parse(ctx.matchPrefix(LocalDateTimeType.PATTERN).group() + ctx.matchPrefix(ZoneOffsetType.PATTERN).group());
    }

    @Override
    public String toParseableString(OffsetDateTime offsetDateTime) {
        return offsetDateTime.toString();
    }
}

