/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import io.permazen.core.FieldType;
import io.permazen.core.FieldTypeRegistry;
import io.permazen.core.InvalidReferenceException;
import io.permazen.core.ObjId;
import io.permazen.core.type.NullSafeType;
import io.permazen.util.ByteWriter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ReferenceFieldType
extends NullSafeType<ObjId> {
    private static final long serialVersionUID = -5980288575339951079L;
    private final TreeSet<Integer> objectTypes;

    public ReferenceFieldType() {
        this((Set<Integer>)null);
    }

    public ReferenceFieldType(Set<Integer> objectTypes) {
        super("reference", FieldTypeRegistry.OBJ_ID);
        this.objectTypes = objectTypes != null ? new TreeSet<Integer>(objectTypes) : null;
    }

    public SortedSet<Integer> getObjectTypes() {
        return this.objectTypes != null ? Collections.unmodifiableSortedSet(this.objectTypes) : null;
    }

    @Override
    public void write(ByteWriter writer, ObjId id) {
        super.write(writer, this.checkAllowed(id));
    }

    @Override
    public ObjId validate(Object obj) {
        return this.checkAllowed((ObjId)super.validate(obj));
    }

    protected ObjId checkAllowed(ObjId id) {
        if (this.objectTypes != null && id != null && !this.objectTypes.contains(id.getStorageId())) {
            throw new InvalidReferenceException(id, this.objectTypes);
        }
        return id;
    }

    @Override
    public <S> ObjId convert(FieldType<S> type, S value) {
        return this.validate(value);
    }

    @Override
    public ReferenceFieldType genericizeForIndex() {
        return this.objectTypes != null ? new ReferenceFieldType() : this;
    }

    @Override
    public String toString() {
        String desc = super.toString();
        if (this.objectTypes != null) {
            desc = desc + " to " + this.objectTypes;
        }
        return desc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ReferenceFieldType that = (ReferenceFieldType)obj;
        return Objects.equals(this.objectTypes, that.objectTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.objectTypes);
    }
}

