/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Converter;
import io.permazen.core.type.StringEncodedType;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public class URIType
extends StringEncodedType<URI> {
    private static final long serialVersionUID = -7746505152033541526L;

    public URIType() {
        super(URI.class, 0L, new URIConverter());
    }

    private static class URIConverter
    extends Converter<URI, String>
    implements Serializable {
        private static final long serialVersionUID = 5035968898458406721L;

        private URIConverter() {
        }

        protected String doForward(URI uri) {
            if (uri == null) {
                return null;
            }
            return uri.toString();
        }

        protected URI doBackward(String string) {
            if (string == null) {
                return null;
            }
            try {
                return new URI(string);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("invalid URI `" + string + "'", e);
            }
        }
    }
}

