/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.time.YearMonth;
import java.util.regex.Pattern;

public class YearMonthType
extends NonNullFieldType<YearMonth> {
    private static final Pattern PATTERN = Pattern.compile("-?[0-9]+-[0-9]+");
    private static final long serialVersionUID = 2773124141026846109L;

    public YearMonthType() {
        super(YearMonth.class, 0L);
    }

    @Override
    public YearMonth read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return YearMonth.of((int)LongEncoder.read((ByteReader)reader), (int)LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, YearMonth yearMonth) {
        Preconditions.checkArgument((yearMonth != null ? 1 : 0) != 0, (Object)"null yearMonth");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)yearMonth.getYear());
        LongEncoder.write((ByteWriter)writer, (long)yearMonth.getMonthValue());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public YearMonth fromParseableString(ParseContext ctx) {
        return YearMonth.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(YearMonth yearMonth) {
        return yearMonth.toString();
    }

    @Override
    public int compare(YearMonth yearMonth1, YearMonth yearMonth2) {
        return yearMonth1.compareTo(yearMonth2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

