/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.type;

import com.google.common.base.Preconditions;
import io.permazen.core.type.NonNullFieldType;
import io.permazen.util.ByteReader;
import io.permazen.util.ByteWriter;
import io.permazen.util.LongEncoder;
import io.permazen.util.ParseContext;
import java.time.Year;
import java.util.regex.Pattern;

public class YearType
extends NonNullFieldType<Year> {
    private static final Pattern PATTERN = Pattern.compile("[-+]?[0-9]+");
    private static final long serialVersionUID = 6800527893478605289L;

    public YearType() {
        super(Year.class, 0L);
    }

    @Override
    public Year read(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        return Year.of((int)LongEncoder.read((ByteReader)reader));
    }

    @Override
    public void write(ByteWriter writer, Year year) {
        Preconditions.checkArgument((year != null ? 1 : 0) != 0, (Object)"null year");
        Preconditions.checkArgument((writer != null ? 1 : 0) != 0);
        LongEncoder.write((ByteWriter)writer, (long)year.getValue());
    }

    @Override
    public void skip(ByteReader reader) {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0);
        reader.skip(LongEncoder.decodeLength((int)reader.peek()));
    }

    @Override
    public Year fromParseableString(ParseContext ctx) {
        return Year.parse(ctx.matchPrefix(PATTERN).group());
    }

    @Override
    public String toParseableString(Year year) {
        int value = year.getValue();
        String sign = "";
        if (value < 0) {
            value = -value;
            sign = "-";
        }
        if (value > 9999) {
            sign = "+";
        }
        return String.format("%s%04d", sign, value);
    }

    @Override
    public int compare(Year year1, Year year2) {
        return year1.compareTo(year2);
    }

    @Override
    public boolean hasPrefix0x00() {
        return false;
    }

    @Override
    public boolean hasPrefix0xff() {
        return false;
    }
}

