/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.core.util;

import com.google.common.base.Preconditions;
import io.permazen.core.ObjId;
import io.permazen.core.util.ObjIdMap;
import io.permazen.core.util.ObjIdSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ObjIdBiMultiMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2063318188143069113L;
    @GuardedBy(value="this")
    private transient Object lock;
    @GuardedBy(value="this")
    private transient ObjIdBiMultiMap inverse;
    @GuardedBy(value="this")
    private ObjIdMap<ObjIdSet> forward;
    @GuardedBy(value="this")
    private ObjIdMap<ObjIdSet> reverse;

    public ObjIdBiMultiMap() {
        this(0, 0);
    }

    public ObjIdBiMultiMap(int sourceCapacity, int targetCapacity) {
        this(null, new ObjIdMap<ObjIdSet>(sourceCapacity), new ObjIdMap<ObjIdSet>(targetCapacity));
    }

    private ObjIdBiMultiMap(ObjIdBiMultiMap inverse, ObjIdMap<ObjIdSet> forward, ObjIdMap<ObjIdSet> reverse) {
        if (inverse != null) {
            this.lock = inverse.lock;
            this.inverse = inverse;
        } else {
            this.lock = new Object();
            this.inverse = null;
        }
        this.forward = forward;
        this.reverse = reverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumSources() {
        Object object = this.lock;
        synchronized (object) {
            return this.forward.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTargets() {
        Object object = this.lock;
        synchronized (object) {
            return this.reverse.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjIdSet getSources() {
        Object object = this.lock;
        synchronized (object) {
            return this.forward.keySet().clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjIdSet getTargets() {
        Object object = this.lock;
        synchronized (object) {
            return this.reverse.keySet().clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjIdSet getSources(ObjId target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        Object object = this.lock;
        synchronized (object) {
            ObjIdSet sources = this.reverse.get(target);
            return sources != null ? sources.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjIdSet getTargets(ObjId source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Object object = this.lock;
        synchronized (object) {
            ObjIdSet targets = this.forward.get(source);
            return targets != null ? targets.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSource(ObjId source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Object object = this.lock;
        synchronized (object) {
            return this.forward.containsKey(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTarget(ObjId target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        Object object = this.lock;
        synchronized (object) {
            return this.reverse.containsKey(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjId source, ObjId target) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        Object object = this.lock;
        synchronized (object) {
            if (!ObjIdBiMultiMap.add(this.forward, source, target)) {
                return false;
            }
            ObjIdBiMultiMap.add(this.reverse, target, source);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ObjId source, Iterable<? extends ObjId> targets) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((targets != null ? 1 : 0) != 0, (Object)"null targets");
        ObjIdSet addedTargets = ObjIdBiMultiMap.gather(targets);
        if (addedTargets.isEmpty()) {
            return false;
        }
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            ObjIdSet targetSet = this.forward.get(source);
            if (targetSet != null) {
                assert (!targetSet.isEmpty());
                if (targetSet.size() >= addedTargets.size()) {
                    result = targetSet.addAll(addedTargets);
                } else {
                    addedTargets.addAll(targetSet);
                    this.forward.put(source, addedTargets);
                    result = true;
                }
            } else {
                this.forward.put(source, addedTargets);
                result = true;
            }
            for (ObjId target : addedTargets) {
                ObjIdBiMultiMap.add(this.reverse, target, source);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ObjId source, ObjId target) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        Object object = this.lock;
        synchronized (object) {
            if (!ObjIdBiMultiMap.remove(this.forward, source, target)) {
                return false;
            }
            ObjIdBiMultiMap.remove(this.reverse, target, source);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjId source, Iterable<? extends ObjId> targets) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((targets != null ? 1 : 0) != 0, (Object)"null targets");
        ObjIdSet removedTargets = ObjIdBiMultiMap.gather(targets);
        if (removedTargets.isEmpty()) {
            return false;
        }
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            ObjIdSet targetSet = this.forward.get(source);
            if (targetSet == null) {
                return false;
            }
            assert (!targetSet.isEmpty());
            for (ObjId target : removedTargets) {
                if (!targetSet.remove(target)) continue;
                boolean removed = ObjIdBiMultiMap.remove(this.reverse, target, source);
                assert (removed);
                result = true;
            }
            if (targetSet.isEmpty()) {
                this.forward.remove(source);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSource(ObjId source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Object object = this.lock;
        synchronized (object) {
            ObjIdSet targets = this.forward.remove(source);
            if (targets == null) {
                return false;
            }
            assert (!targets.isEmpty());
            for (ObjId target : targets) {
                ObjIdSet sources = this.reverse.get(target);
                sources.remove(source);
                if (!sources.isEmpty()) continue;
                this.reverse.remove(target);
            }
        }
        return true;
    }

    public boolean removeTarget(ObjId target) {
        return this.inverse().removeSource(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.forward.clear();
            this.reverse.clear();
        }
    }

    public ObjIdBiMultiMap inverse() {
        return this.inverse != null ? this.inverse : new ObjIdBiMultiMap(this, this.reverse, this.forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.forward.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        ObjIdMap<ObjIdSet> thatForward;
        ObjIdMap<ObjIdSet> thisForward;
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ObjIdBiMultiMap that = (ObjIdBiMultiMap)obj;
        Object object = this.lock;
        synchronized (object) {
            thisForward = ObjIdBiMultiMap.deepClone(this.forward);
        }
        object = that.lock;
        synchronized (object) {
            thatForward = ObjIdBiMultiMap.deepClone(that.forward);
        }
        return thisForward.equals(thatForward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.forward.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjIdBiMultiMap clone() {
        ObjIdBiMultiMap clone;
        try {
            clone = (ObjIdBiMultiMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        Object object = clone.lock = new Object();
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                clone.forward = ObjIdBiMultiMap.deepClone(this.forward);
                clone.reverse = ObjIdBiMultiMap.deepClone(this.reverse);
            }
            clone.inverse = null;
        }
        return clone;
    }

    private static ObjIdSet gather(Iterable<? extends ObjId> ids) {
        ObjIdSet set = new ObjIdSet();
        for (ObjId objId : ids) {
            Preconditions.checkArgument((objId != null ? 1 : 0) != 0, (Object)"encountered null ObjId in iteration");
            set.add(objId);
        }
        return set;
    }

    private static boolean add(ObjIdMap<ObjIdSet> map, ObjId source, ObjId target) {
        ObjIdSet set = map.get(source);
        if (set == null) {
            set = new ObjIdSet();
            map.put(source, set);
        }
        return set.add(target);
    }

    private static boolean remove(ObjIdMap<ObjIdSet> map, ObjId source, ObjId target) {
        ObjIdSet set = map.get(source);
        if (set == null || !set.remove(target)) {
            return false;
        }
        if (set.isEmpty()) {
            map.remove(source);
        }
        return true;
    }

    private static ObjIdMap<ObjIdSet> deepClone(ObjIdMap<ObjIdSet> map) {
        Object clone = map.clone();
        int numSlots = map.getKeys().length;
        for (int i = 0; i < numSlots; ++i) {
            ObjIdSet set = map.getValue(i);
            if (set == null) continue;
            ((ObjIdMap)clone).setValue(i, set.clone());
        }
        return clone;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.lock = new Object();
    }
}

