/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.schema;

import com.google.common.base.Preconditions;
import io.permazen.core.InvalidSchemaException;
import io.permazen.schema.SchemaSupport;
import io.permazen.schema.XMLConstants;
import io.permazen.util.Diffs;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractSchemaItem
extends SchemaSupport {
    private String name;
    private int storageId;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.verifyNotLockedDown();
        this.name = name;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public void setStorageId(int storageId) {
        this.verifyNotLockedDown();
        this.storageId = storageId;
    }

    void validate() {
        if (this.name == null) {
            throw new InvalidSchemaException(this + " must specify a name");
        }
        if (!this.name.matches("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*")) {
            throw new InvalidSchemaException(this + " has an invalid name `" + this.name + "'");
        }
        if (this.storageId <= 0) {
            throw new InvalidSchemaException(this + " has an invalid storage ID " + this.storageId + "; must be greater than zero");
        }
    }

    static <K, V> boolean isAll(Map<K, V> map1, Map<K, V> map2, BiPredicate<V, V> checker) {
        if (!map1.keySet().equals(map2.keySet())) {
            return false;
        }
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            K key = entry.getKey();
            V value1 = entry.getValue();
            V value2 = map2.get(key);
            if (value1 != null && value2 != null && checker.test(value1, value2)) continue;
            return false;
        }
        return true;
    }

    void writeCompatibilityHashData(DataOutputStream output) throws IOException {
        output.writeUTF(this.getClass().getSimpleName());
        output.writeInt(this.storageId);
    }

    protected Diffs differencesFrom(AbstractSchemaItem that) {
        Preconditions.checkArgument((that != null ? 1 : 0) != 0, (Object)"null that");
        Diffs diffs = new Diffs();
        if (!(this.name == null ? that.name == null : this.name.equals(that.name))) {
            diffs.add("changed name from " + (that.name != null ? "`" + that.name + "'" : null) + " to " + (this.name != null ? "`" + this.name + "'" : null));
        }
        if (this.storageId != that.storageId) {
            diffs.add("changed storage ID from " + that.storageId + " to " + this.storageId);
        }
        return diffs;
    }

    void readXML(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        this.readAttributes(reader, formatVersion);
        this.readSubElements(reader, formatVersion);
    }

    void readAttributes(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        String nameAttr;
        Integer storageIdAttr = this.getIntAttr(reader, XMLConstants.STORAGE_ID_ATTRIBUTE, false);
        if (storageIdAttr != null) {
            this.setStorageId(storageIdAttr);
        }
        if ((nameAttr = this.getAttr(reader, XMLConstants.NAME_ATTRIBUTE, false)) != null) {
            this.setName(nameAttr);
        }
    }

    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        this.expectClose(reader);
    }

    <T> T readMappedType(XMLStreamReader reader, boolean closingOK, Map<QName, Class<? extends T>> tagMap) throws XMLStreamException {
        if (!this.expect(reader, closingOK, tagMap.keySet().toArray(new QName[tagMap.size()]))) {
            return null;
        }
        Object obj = null;
        for (Map.Entry<QName, Class<T>> entry : tagMap.entrySet()) {
            if (!reader.getName().equals(entry.getKey())) continue;
            try {
                return entry.getValue().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unexpected exception", e);
            }
        }
        throw new RuntimeException("internal error: didn't find " + reader.getName() + " in tagMap");
    }

    <T extends Enum<T>> T readAttr(XMLStreamReader reader, Class<T> type, QName name, T defaultValue) throws XMLStreamException {
        String text = this.getAttr(reader, name, defaultValue == null);
        if (text == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(type, text);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("invalid value `" + text + " for \"" + name.getLocalPart() + "\" attribute in " + this, reader.getLocation());
        }
    }

    abstract void writeXML(XMLStreamWriter var1) throws XMLStreamException;

    final void writeAttributes(XMLStreamWriter writer) throws XMLStreamException {
        this.writeAttributes(writer, true);
    }

    void writeAttributes(XMLStreamWriter writer, boolean includeName) throws XMLStreamException {
        writer.writeAttribute(XMLConstants.STORAGE_ID_ATTRIBUTE.getNamespaceURI(), XMLConstants.STORAGE_ID_ATTRIBUTE.getLocalPart(), "" + this.storageId);
        if (includeName && this.name != null) {
            writer.writeAttribute(XMLConstants.NAME_ATTRIBUTE.getNamespaceURI(), XMLConstants.NAME_ATTRIBUTE.getLocalPart(), this.name);
        }
    }

    public String toString() {
        return "#" + this.storageId + (this.name != null ? " `" + this.name + "'" : "");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractSchemaItem that = (AbstractSchemaItem)obj;
        return Objects.equals(this.name, that.name) && this.storageId == that.storageId;
    }

    public int hashCode() {
        return Objects.hashCode(this.name) ^ this.storageId;
    }

    @Override
    protected AbstractSchemaItem clone() {
        return (AbstractSchemaItem)super.clone();
    }
}

