/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.schema;

import io.permazen.schema.ComplexSchemaField;
import io.permazen.schema.SchemaFieldSwitch;
import io.permazen.schema.SimpleSchemaField;
import io.permazen.schema.XMLConstants;
import io.permazen.util.DiffGenerating;
import io.permazen.util.Diffs;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MapSchemaField
extends ComplexSchemaField
implements DiffGenerating<MapSchemaField> {
    private SimpleSchemaField keyField;
    private SimpleSchemaField valueField;

    public SimpleSchemaField getKeyField() {
        return this.keyField;
    }

    public void setKeyField(SimpleSchemaField keyField) {
        this.verifyNotLockedDown();
        this.keyField = keyField;
    }

    public SimpleSchemaField getValueField() {
        return this.valueField;
    }

    public void setValueField(SimpleSchemaField valueField) {
        this.verifyNotLockedDown();
        this.valueField = valueField;
    }

    @Override
    public Map<String, SimpleSchemaField> getSubFields() {
        LinkedHashMap<String, SimpleSchemaField> map = new LinkedHashMap<String, SimpleSchemaField>(2);
        map.put("key", this.keyField);
        map.put("value", this.valueField);
        return map;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        if (this.keyField != null) {
            this.keyField.lockDown();
        }
        if (this.valueField != null) {
            this.valueField.lockDown();
        }
    }

    @Override
    public <R> R visit(SchemaFieldSwitch<R> target) {
        return target.caseMapSchemaField(this);
    }

    @Override
    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        this.keyField = this.readSubField(reader, formatVersion, "key");
        this.valueField = this.readSubField(reader, formatVersion, "value");
        this.expectClose(reader);
    }

    @Override
    QName getXMLTag() {
        return XMLConstants.MAP_FIELD_TAG;
    }

    public Diffs differencesFrom(MapSchemaField that) {
        Diffs valueDiffs;
        Diffs diffs = new Diffs(super.differencesFrom(that));
        Diffs keyDiffs = this.keyField.differencesFrom(that.keyField);
        if (!keyDiffs.isEmpty()) {
            diffs.add("changed key field", keyDiffs);
        }
        if (!(valueDiffs = this.valueField.differencesFrom(that.valueField)).isEmpty()) {
            diffs.add("changed value field", valueDiffs);
        }
        return diffs;
    }

    @Override
    public String toString() {
        return "map " + super.toString() + " with key " + this.keyField + " and value " + this.valueField;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MapSchemaField that = (MapSchemaField)obj;
        return Objects.equals(this.keyField, that.keyField) && Objects.equals(this.valueField, that.valueField);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Objects.hashCode(this.keyField) ^ Objects.hashCode(this.valueField);
    }

    @Override
    public MapSchemaField clone() {
        MapSchemaField clone = (MapSchemaField)super.clone();
        if (clone.keyField != null) {
            clone.keyField = clone.keyField.clone();
        }
        if (clone.valueField != null) {
            clone.valueField = clone.valueField.clone();
        }
        return clone;
    }
}

