/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.schema;

import com.google.common.base.Preconditions;
import io.permazen.schema.SchemaCompositeIndex;
import io.permazen.schema.SchemaField;
import io.permazen.schema.SchemaModel;
import io.permazen.schema.SchemaObjectType;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.TreeMap;

public class NameIndex {
    private final SchemaModel schemaModel;
    private final TreeMap<String, SchemaObjectType> typeMap = new TreeMap();
    private final TreeMap<Integer, TreeMap<String, SchemaField>> typeFieldMap = new TreeMap();
    private final TreeMap<Integer, TreeMap<String, SchemaCompositeIndex>> typeCompositeIndexMap = new TreeMap();

    public NameIndex(SchemaModel schemaModel) {
        Preconditions.checkArgument((schemaModel != null ? 1 : 0) != 0, (Object)"null schemaModel");
        this.schemaModel = schemaModel;
        for (SchemaObjectType type : schemaModel.getSchemaObjectTypes().values()) {
            if (this.typeMap.put(type.getName(), type) != null) {
                throw new IllegalArgumentException("schema model is invalid");
            }
            TreeMap<String, SchemaField> fieldMap = new TreeMap<String, SchemaField>();
            this.typeFieldMap.put(type.getStorageId(), fieldMap);
            for (SchemaField field : type.getSchemaFields().values()) {
                if (fieldMap.put(field.getName(), field) == null) continue;
                throw new IllegalArgumentException("schema model is invalid");
            }
            TreeMap<String, SchemaCompositeIndex> compositeIndexMap = new TreeMap<String, SchemaCompositeIndex>();
            this.typeCompositeIndexMap.put(type.getStorageId(), compositeIndexMap);
            for (SchemaCompositeIndex compositeIndex : type.getSchemaCompositeIndexes().values()) {
                if (compositeIndexMap.put(compositeIndex.getName(), compositeIndex) == null) continue;
                throw new IllegalArgumentException("schema model is invalid");
            }
        }
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public SchemaObjectType getSchemaObjectType(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        return this.typeMap.get(name);
    }

    public NavigableSet<String> getSchemaObjectTypeNames() {
        return Collections.unmodifiableNavigableSet(this.typeMap.navigableKeySet());
    }

    public SchemaField getSchemaField(SchemaObjectType type, String name) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        TreeMap<String, SchemaField> fieldMap = this.typeFieldMap.get(type.getStorageId());
        if (fieldMap == null) {
            throw new IllegalArgumentException("unknown type `" + type.getName() + "' with storage ID " + type.getStorageId());
        }
        return fieldMap.get(name);
    }

    public NavigableSet<String> getSchemaFieldNames(SchemaObjectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        TreeMap<String, SchemaField> fieldMap = this.typeFieldMap.get(type.getStorageId());
        if (fieldMap == null) {
            throw new IllegalArgumentException("unknown type `" + type.getName() + "' with storage ID " + type.getStorageId());
        }
        return Collections.unmodifiableNavigableSet(fieldMap.navigableKeySet());
    }

    public SchemaCompositeIndex getSchemaCompositeIndex(SchemaObjectType type, String name) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        TreeMap<String, SchemaCompositeIndex> indexMap = this.typeCompositeIndexMap.get(type.getStorageId());
        if (indexMap == null) {
            throw new IllegalArgumentException("unknown type `" + type.getName() + "' with storage ID " + type.getStorageId());
        }
        return indexMap.get(name);
    }

    public NavigableSet<String> getSchemaCompositeIndexNames(SchemaObjectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        TreeMap<String, SchemaCompositeIndex> indexMap = this.typeCompositeIndexMap.get(type.getStorageId());
        if (indexMap == null) {
            throw new IllegalArgumentException("unknown type `" + type.getName() + "' with storage ID " + type.getStorageId());
        }
        return Collections.unmodifiableNavigableSet(indexMap.navigableKeySet());
    }
}

