/*
 * Decompiled with CFR 0.152.
 */
package io.permazen.schema;

import io.permazen.core.InvalidSchemaException;
import io.permazen.schema.AbstractSchemaItem;
import io.permazen.schema.CounterSchemaField;
import io.permazen.schema.EnumSchemaField;
import io.permazen.schema.ListSchemaField;
import io.permazen.schema.MapSchemaField;
import io.permazen.schema.ReferenceSchemaField;
import io.permazen.schema.SchemaCompositeIndex;
import io.permazen.schema.SchemaField;
import io.permazen.schema.SchemaFieldSwitch;
import io.permazen.schema.SchemaModel;
import io.permazen.schema.SetSchemaField;
import io.permazen.schema.SimpleSchemaField;
import io.permazen.schema.XMLConstants;
import io.permazen.util.DiffGenerating;
import io.permazen.util.Diffs;
import io.permazen.util.NavigableSets;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SchemaObjectType
extends AbstractSchemaItem
implements DiffGenerating<SchemaObjectType> {
    private NavigableMap<Integer, SchemaField> schemaFields = new TreeMap<Integer, SchemaField>();
    private NavigableMap<Integer, SchemaCompositeIndex> schemaCompositeIndexes = new TreeMap<Integer, SchemaCompositeIndex>();

    public NavigableMap<Integer, SchemaField> getSchemaFields() {
        return this.schemaFields;
    }

    public NavigableMap<Integer, SchemaCompositeIndex> getSchemaCompositeIndexes() {
        return this.schemaCompositeIndexes;
    }

    @Override
    void lockDownRecurse() {
        super.lockDownRecurse();
        this.schemaFields = Collections.unmodifiableNavigableMap(this.schemaFields);
        for (SchemaField schemaField : this.schemaFields.values()) {
            schemaField.lockDown();
        }
        this.schemaCompositeIndexes = Collections.unmodifiableNavigableMap(this.schemaCompositeIndexes);
        for (SchemaCompositeIndex schemaCompositeIndex : this.schemaCompositeIndexes.values()) {
            schemaCompositeIndex.lockDown();
        }
    }

    @Override
    void validate() {
        Object indexName;
        super.validate();
        TreeMap fieldsByName = new TreeMap();
        for (Iterator field : this.schemaFields.values()) {
            ((AbstractSchemaItem)((Object)field)).validate();
            String fieldName = ((AbstractSchemaItem)((Object)field)).getName();
            if (fieldsByName.put(fieldName, field) == null) continue;
            throw new InvalidSchemaException("duplicate field name `" + fieldName + "'");
        }
        TreeMap<String, SchemaCompositeIndex> compositeIndexesByName = new TreeMap<String, SchemaCompositeIndex>();
        for (SchemaCompositeIndex index : this.schemaCompositeIndexes.values()) {
            index.validate();
            indexName = index.getName();
            if (compositeIndexesByName.put((String)indexName, index) == null) continue;
            throw new InvalidSchemaException("duplicate composite index name `" + (String)indexName + "'");
        }
        for (SchemaCompositeIndex index : this.schemaCompositeIndexes.values()) {
            indexName = index.getIndexedFields().iterator();
            while (indexName.hasNext()) {
                int storageId = (Integer)indexName.next();
                SchemaField field = (SchemaField)this.schemaFields.get(storageId);
                if (field instanceof SimpleSchemaField) continue;
                throw new InvalidSchemaException(index + " indexes unknown or invalid field with storage ID " + storageId);
            }
        }
        HashMap<List<Integer>, SchemaCompositeIndex> compositeIndexFields = new HashMap<List<Integer>, SchemaCompositeIndex>();
        for (SchemaCompositeIndex index : this.schemaCompositeIndexes.values()) {
            SchemaCompositeIndex previous = compositeIndexFields.put(index.getIndexedFields(), index);
            if (previous == null) continue;
            throw new InvalidSchemaException("duplicate " + index + " (duplicates " + previous + ")");
        }
    }

    @Override
    void readSubElements(XMLStreamReader reader, int formatVersion) throws XMLStreamException {
        AbstractSchemaItem item;
        this.schemaFields.clear();
        this.schemaCompositeIndexes.clear();
        boolean seenIndex = false;
        while ((item = (AbstractSchemaItem)this.readMappedType(reader, true, SchemaModel.FIELD_OR_COMPOSITE_INDEX_TAG_MAP)) != null) {
            AbstractSchemaItem previous;
            int storageId;
            if (item instanceof SchemaField) {
                if (seenIndex) {
                    throw new XMLStreamException("indexes must appear after fields", reader.getLocation());
                }
                SchemaField field = (SchemaField)item;
                field.readXML(reader, formatVersion);
                storageId = field.getStorageId();
                previous = this.schemaFields.put(storageId, field);
                if (previous == null) continue;
                throw new XMLStreamException("duplicate use of storage ID " + storageId + " for both " + previous + " and " + field + " in " + this, reader.getLocation());
            }
            if (item instanceof SchemaCompositeIndex) {
                SchemaCompositeIndex index = (SchemaCompositeIndex)item;
                index.readXML(reader, formatVersion);
                storageId = index.getStorageId();
                previous = this.schemaCompositeIndexes.put(storageId, index);
                if (previous != null) {
                    throw new XMLStreamException("duplicate use of storage ID " + storageId + " for both " + previous + " and " + index + " in " + this, reader.getLocation());
                }
                seenIndex = true;
                continue;
            }
            throw new RuntimeException("internal error");
        }
    }

    @Override
    void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        if (this.schemaFields.isEmpty() && this.schemaCompositeIndexes.isEmpty()) {
            writer.writeEmptyElement(XMLConstants.OBJECT_TYPE_TAG.getNamespaceURI(), XMLConstants.OBJECT_TYPE_TAG.getLocalPart());
            this.writeAttributes(writer);
            return;
        }
        writer.writeStartElement(XMLConstants.OBJECT_TYPE_TAG.getNamespaceURI(), XMLConstants.OBJECT_TYPE_TAG.getLocalPart());
        this.writeAttributes(writer);
        ArrayList fieldList = new ArrayList(this.schemaFields.values());
        Collections.sort(fieldList, Comparator.comparing(AbstractSchemaItem::getName));
        for (SchemaField schemaField : fieldList) {
            schemaField.writeXML(writer);
        }
        ArrayList indexList = new ArrayList(this.schemaCompositeIndexes.values());
        Collections.sort(indexList, Comparator.comparing(AbstractSchemaItem::getName));
        for (SchemaCompositeIndex schemaCompositeIndex : indexList) {
            schemaCompositeIndex.writeXML(writer);
        }
        writer.writeEndElement();
    }

    boolean isCompatibleWith(SchemaObjectType that) {
        return AbstractSchemaItem.isAll(this.schemaFields, that.schemaFields, SchemaField::isCompatibleWith) && AbstractSchemaItem.isAll(this.schemaCompositeIndexes, that.schemaCompositeIndexes, SchemaCompositeIndex::isCompatibleWith);
    }

    @Override
    void writeCompatibilityHashData(DataOutputStream output) throws IOException {
        super.writeCompatibilityHashData(output);
        output.writeInt(this.schemaFields.size());
        for (SchemaField field : this.schemaFields.values()) {
            field.writeCompatibilityHashData(output);
        }
        output.writeInt(this.schemaCompositeIndexes.size());
        for (SchemaCompositeIndex index : this.schemaCompositeIndexes.values()) {
            index.writeCompatibilityHashData(output);
        }
    }

    public Diffs differencesFrom(SchemaObjectType that) {
        Diffs diffs = new Diffs(super.differencesFrom(that));
        NavigableSet allFieldIds = NavigableSets.union((NavigableSet[])new NavigableSet[]{this.schemaFields.navigableKeySet(), that.schemaFields.navigableKeySet()});
        Iterator iterator = allFieldIds.iterator();
        while (iterator.hasNext()) {
            int storageId = (Integer)iterator.next();
            SchemaField thisField = (SchemaField)this.schemaFields.get(storageId);
            final SchemaField thatField = (SchemaField)that.schemaFields.get(storageId);
            if (!(thatField == null || thisField != null && thisField.getClass().equals(thatField.getClass()))) {
                diffs.add("removed " + thatField);
                continue;
            }
            if (!(thisField == null || thatField != null && thatField.getClass().equals(thisField.getClass()))) {
                diffs.add("added " + thisField);
                continue;
            }
            Diffs fieldDiffs = thisField.visit(new SchemaFieldSwitch<Diffs>(){

                @Override
                public Diffs caseSetSchemaField(SetSchemaField field) {
                    return field.differencesFrom((SetSchemaField)thatField);
                }

                @Override
                public Diffs caseListSchemaField(ListSchemaField field) {
                    return field.differencesFrom((ListSchemaField)thatField);
                }

                @Override
                public Diffs caseMapSchemaField(MapSchemaField field) {
                    return field.differencesFrom((MapSchemaField)thatField);
                }

                @Override
                public Diffs caseSimpleSchemaField(SimpleSchemaField field) {
                    return field.differencesFrom((SimpleSchemaField)thatField);
                }

                @Override
                public Diffs caseReferenceSchemaField(ReferenceSchemaField field) {
                    return field.differencesFrom((ReferenceSchemaField)thatField);
                }

                @Override
                public Diffs caseEnumSchemaField(EnumSchemaField field) {
                    return field.differencesFrom((EnumSchemaField)thatField);
                }

                @Override
                public Diffs caseCounterSchemaField(CounterSchemaField field) {
                    return new Diffs();
                }
            });
            if (fieldDiffs.isEmpty()) continue;
            diffs.add("changed " + thatField, fieldDiffs);
        }
        NavigableSet allIndexIds = NavigableSets.union((NavigableSet[])new NavigableSet[]{this.schemaCompositeIndexes.navigableKeySet(), that.schemaCompositeIndexes.navigableKeySet()});
        Iterator iterator2 = allIndexIds.iterator();
        while (iterator2.hasNext()) {
            int storageId = (Integer)iterator2.next();
            SchemaCompositeIndex thisIndex = (SchemaCompositeIndex)this.schemaCompositeIndexes.get(storageId);
            SchemaCompositeIndex thatIndex = (SchemaCompositeIndex)that.schemaCompositeIndexes.get(storageId);
            if (thisIndex == null) {
                diffs.add("removed " + thatIndex);
                continue;
            }
            if (thatIndex == null) {
                diffs.add("added " + thisIndex);
                continue;
            }
            Diffs indexDiffs = thisIndex.differencesFrom(thatIndex);
            if (indexDiffs.isEmpty()) continue;
            diffs.add("changed " + thatIndex, indexDiffs);
        }
        return diffs;
    }

    @Override
    public String toString() {
        return "object " + super.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SchemaObjectType that = (SchemaObjectType)obj;
        return this.schemaFields.equals(that.schemaFields) && this.schemaCompositeIndexes.equals(that.schemaCompositeIndexes);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.schemaFields.hashCode() ^ this.schemaCompositeIndexes.hashCode();
    }

    @Override
    public SchemaObjectType clone() {
        SchemaObjectType clone = (SchemaObjectType)super.clone();
        clone.schemaFields = new TreeMap<Integer, SchemaField>((SortedMap<Integer, SchemaField>)clone.schemaFields);
        for (Map.Entry entry : clone.schemaFields.entrySet()) {
            entry.setValue(((SchemaField)entry.getValue()).clone());
        }
        clone.schemaCompositeIndexes = new TreeMap<Integer, SchemaCompositeIndex>((SortedMap<Integer, SchemaCompositeIndex>)clone.schemaCompositeIndexes);
        for (Map.Entry entry : clone.schemaCompositeIndexes.entrySet()) {
            entry.setValue(((SchemaCompositeIndex)entry.getValue()).clone());
        }
        return clone;
    }
}

